rule win_selfmake_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.selfmake."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.selfmake"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? c644247801 837c244810 720d }
            // n = 4, score = 400
            //   e8????????           |                     
            //   c644247801           | mov                 byte ptr [esp + 0x78], 1
            //   837c244810           | cmp                 dword ptr [esp + 0x48], 0x10
            //   720d                 | jb                  0xf

        $sequence_1 = { c1e902 8bf2 f3a5 8bc8 83e103 6a0a f3a4 }
            // n = 7, score = 400
            //   c1e902               | shr                 ecx, 2
            //   8bf2                 | mov                 esi, edx
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax
            //   83e103               | and                 ecx, 3
            //   6a0a                 | push                0xa
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]

        $sequence_2 = { 68???????? e8???????? 83c040 50 e8???????? 8b5608 8b4254 }
            // n = 7, score = 400
            //   68????????           |                     
            //   e8????????           |                     
            //   83c040               | add                 eax, 0x40
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b5608               | mov                 edx, dword ptr [esi + 8]
            //   8b4254               | mov                 eax, dword ptr [edx + 0x54]

        $sequence_3 = { 57 8d7c2414 e8???????? 83c404 83f8ff 751d 68???????? }
            // n = 7, score = 400
            //   57                   | push                edi
            //   8d7c2414             | lea                 edi, [esp + 0x14]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   83f8ff               | cmp                 eax, -1
            //   751d                 | jne                 0x1f
            //   68????????           |                     

        $sequence_4 = { 3bf3 760a 2bf3 eb08 8b5c246c ebe7 }
            // n = 6, score = 400
            //   3bf3                 | cmp                 esi, ebx
            //   760a                 | jbe                 0xc
            //   2bf3                 | sub                 esi, ebx
            //   eb08                 | jmp                 0xa
            //   8b5c246c             | mov                 ebx, dword ptr [esp + 0x6c]
            //   ebe7                 | jmp                 0xffffffe9

        $sequence_5 = { 83c408 6818020000 6a00 8d8de0fdffff 51 e8???????? 83c40c }
            // n = 7, score = 400
            //   83c408               | add                 esp, 8
            //   6818020000           | push                0x218
            //   6a00                 | push                0
            //   8d8de0fdffff         | lea                 ecx, [ebp - 0x220]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_6 = { 8be8 6a1f 55 ff15???????? }
            // n = 4, score = 400
            //   8be8                 | mov                 ebp, eax
            //   6a1f                 | push                0x1f
            //   55                   | push                ebp
            //   ff15????????         |                     

        $sequence_7 = { 80387f 0f844e010000 8bc2 83f910 }
            // n = 4, score = 400
            //   80387f               | cmp                 byte ptr [eax], 0x7f
            //   0f844e010000         | je                  0x154
            //   8bc2                 | mov                 eax, edx
            //   83f910               | cmp                 ecx, 0x10

        $sequence_8 = { 51 8b95a0fbffff 52 ff15???????? 8945f8 837df800 }
            // n = 6, score = 400
            //   51                   | push                ecx
            //   8b95a0fbffff         | mov                 edx, dword ptr [ebp - 0x460]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   837df800             | cmp                 dword ptr [ebp - 8], 0

        $sequence_9 = { 33c0 e9???????? 8d95c0fbffff 52 }
            // n = 4, score = 400
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   8d95c0fbffff         | lea                 edx, [ebp - 0x440]
            //   52                   | push                edx

    condition:
        7 of them and filesize < 932864
}