rule win_sendsafe_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sendsafe."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sendsafe"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b5508 52 8d45bc 50 e8???????? 83c40c 8d4dbc }
            // n = 7, score = 200
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   52                   | push                edx
            //   8d45bc               | lea                 eax, [ebp - 0x44]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d4dbc               | lea                 ecx, [ebp - 0x44]

        $sequence_1 = { eb07 c745dc00000000 0fb645dc 85c0 0f842f010000 8b4dfc 83c110 }
            // n = 7, score = 200
            //   eb07                 | jmp                 9
            //   c745dc00000000       | mov                 dword ptr [ebp - 0x24], 0
            //   0fb645dc             | movzx               eax, byte ptr [ebp - 0x24]
            //   85c0                 | test                eax, eax
            //   0f842f010000         | je                  0x135
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   83c110               | add                 ecx, 0x10

        $sequence_2 = { ffd2 83c408 e9???????? 8b4508 8b08 c741146d000000 8b5508 }
            // n = 7, score = 200
            //   ffd2                 | call                edx
            //   83c408               | add                 esp, 8
            //   e9????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   c741146d000000       | mov                 dword ptr [ecx + 0x14], 0x6d
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_3 = { b904000000 6bd10e 8b4dfc 33441110 3345f4 8945f4 8b55f4 }
            // n = 7, score = 200
            //   b904000000           | mov                 ecx, 4
            //   6bd10e               | imul                edx, ecx, 0xe
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   33441110             | xor                 eax, dword ptr [ecx + edx + 0x10]
            //   3345f4               | xor                 eax, dword ptr [ebp - 0xc]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]

        $sequence_4 = { 8b952cfdffff 837a1410 721c 8b8564fcffff 898524fdffff 8b8d2cfdffff 8b11 }
            // n = 7, score = 200
            //   8b952cfdffff         | mov                 edx, dword ptr [ebp - 0x2d4]
            //   837a1410             | cmp                 dword ptr [edx + 0x14], 0x10
            //   721c                 | jb                  0x1e
            //   8b8564fcffff         | mov                 eax, dword ptr [ebp - 0x39c]
            //   898524fdffff         | mov                 dword ptr [ebp - 0x2dc], eax
            //   8b8d2cfdffff         | mov                 ecx, dword ptr [ebp - 0x2d4]
            //   8b11                 | mov                 edx, dword ptr [ecx]

        $sequence_5 = { e8???????? 83c414 85c0 0f84e1010000 ff7518 8d4704 57 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   85c0                 | test                eax, eax
            //   0f84e1010000         | je                  0x1e7
            //   ff7518               | push                dword ptr [ebp + 0x18]
            //   8d4704               | lea                 eax, [edi + 4]
            //   57                   | push                edi

        $sequence_6 = { e8???????? 83c408 8b4dfc 89411c 8b5508 8b8214010000 c1e003 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   89411c               | mov                 dword ptr [ecx + 0x1c], eax
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b8214010000         | mov                 eax, dword ptr [edx + 0x114]
            //   c1e003               | shl                 eax, 3

        $sequence_7 = { e9???????? e8???????? 8bd0 89542434 85d2 7511 684f060000 }
            // n = 7, score = 200
            //   e9????????           |                     
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   89542434             | mov                 dword ptr [esp + 0x34], edx
            //   85d2                 | test                edx, edx
            //   7511                 | jne                 0x13
            //   684f060000           | push                0x64f

        $sequence_8 = { eb1e 8b55f4 833a00 7406 c645fe01 eb04 c645fe00 }
            // n = 7, score = 200
            //   eb1e                 | jmp                 0x20
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   833a00               | cmp                 dword ptr [edx], 0
            //   7406                 | je                  8
            //   c645fe01             | mov                 byte ptr [ebp - 2], 1
            //   eb04                 | jmp                 6
            //   c645fe00             | mov                 byte ptr [ebp - 2], 0

        $sequence_9 = { ff15???????? 8d5508 52 8b4dfc 83c104 e8???????? 8945f8 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   8d5508               | lea                 edx, [ebp + 8]
            //   52                   | push                edx
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   83c104               | add                 ecx, 4
            //   e8????????           |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

    condition:
        7 of them and filesize < 3743744
}