rule win_sepsys_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sepsys."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sepsys"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 8b542430 488b4c2470 e8???????? 668944243c 0fb744243c 83f805 }
            // n = 7, score = 400
            //   e9????????           |                     
            //   8b542430             | dec                 eax
            //   488b4c2470           | mov                 dword ptr [esp + 0x168], eax
            //   e8????????           |                     
            //   668944243c           | dec                 eax
            //   0fb744243c           | mov                 ecx, dword ptr [esp + 0x160]
            //   83f805               | dec                 eax

        $sequence_1 = { e8???????? 4889842490000000 e9???????? 488b8424e8000000 4889842458010000 488b8424f0000000 4889842460010000 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   4889842490000000     | dec                 eax
            //   e9????????           |                     
            //   488b8424e8000000     | mov                 eax, dword ptr [esp + 0x2b0]
            //   4889842458010000     | dec                 eax
            //   488b8424f0000000     | add                 eax, 8
            //   4889842460010000     | dec                 eax

        $sequence_2 = { 49f7d0 4d01e0 4883e003 7424 31c9 0f1f840000000000 8d140f }
            // n = 7, score = 400
            //   49f7d0               | dec                 eax
            //   4d01e0               | mov                 dword ptr [ecx + 0x10], eax
            //   4883e003             | movaps              xmm0, xmmword ptr [ebp + 0x40]
            //   7424                 | jmp                 0x5c4
            //   31c9                 | movzx               ecx, word ptr [ebp - 0x40]
            //   0f1f840000000000     | mov                 word ptr [ebp - 0x17], cx
            //   8d140f               | mov                 cl, byte ptr [ebp - 0x3e]

        $sequence_3 = { e8???????? 488955b8 488945b0 eb00 c6450700 4889e0 488b4db8 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   488955b8             | dec                 eax
            //   488945b0             | add                 eax, dword ptr [ecx + 0x108]
            //   eb00                 | dec                 eax
            //   c6450700             | mov                 ecx, dword ptr [esp + 0x120]
            //   4889e0               | dec                 eax
            //   488b4db8             | mov                 dword ptr [ecx + 0x108], eax

        $sequence_4 = { 8b5511 8b5d14 895518 895d1b c6460802 8b11 8b4903 }
            // n = 7, score = 400
            //   8b5511               | dec                 eax
            //   8b5d14               | mov                 eax, dword ptr [ebp + 0x2e0]
            //   895518               | mov                 byte ptr [ebp + 0x2ea], 1
            //   895d1b               | dec                 eax
            //   c6460802             | cmp                 dword ptr [ebp + 0x2b8], 0
            //   8b11                 | je                  0x1d43
            //   8b4903               | jmp                 0x1d6d

        $sequence_5 = { 8b1488 448b85f4050000 488d8518040000 488985500a0000 488b8d500a0000 89957c010000 44898578010000 }
            // n = 7, score = 400
            //   8b1488               | je                  0x918
            //   448b85f4050000       | dec                 eax
            //   488d8518040000       | mov                 ecx, dword ptr [esp + 0x20]
            //   488985500a0000       | dec                 eax
            //   488b8d500a0000       | mov                 eax, dword ptr [esp + 0x30]
            //   89957c010000         | dec                 eax
            //   44898578010000       | mov                 ecx, dword ptr [eax + 8]

        $sequence_6 = { e8???????? eb00 488d8d80000000 488d95a0000000 e8???????? eb00 8b8580000000 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   eb00                 | mov                 dword ptr [esp + 0x20], eax
            //   488d8d80000000       | dec                 esp
            //   488d95a0000000       | mov                 ecx, dword ptr [esp + 0x1c8]
            //   e8????????           |                     
            //   eb00                 | dec                 esp
            //   8b8580000000         | mov                 eax, dword ptr [esp + 0x188]

        $sequence_7 = { e9???????? 4c8d4c243f 4c8d44243c 488b942450020000 488b842450020000 488b4810 e8???????? }
            // n = 7, score = 400
            //   e9????????           |                     
            //   4c8d4c243f           | mov                 dword ptr [ebx + 0x7690], eax
            //   4c8d44243c           | dec                 eax
            //   488b942450020000     | mov                 eax, dword ptr [ebx + 0x7680]
            //   488b842450020000     | dec                 eax
            //   488b4810             | mov                 dword ptr [ebx + 0x7698], eax
            //   e8????????           |                     

        $sequence_8 = { e9???????? 807c243400 4c8b6c2440 0f8437020000 4889f9 4889f2 e8???????? }
            // n = 7, score = 400
            //   e9????????           |                     
            //   807c243400           | mov                 eax, dword ptr [ebx + 0xab0]
            //   4c8b6c2440           | vmovdqa             xmm0, xmmword ptr [ebx + 0xbe0]
            //   0f8437020000         | vmovdqa             xmm1, xmmword ptr [ebx + 0xbe0]
            //   4889f9               | dec                 eax
            //   4889f2               | mov                 dword ptr [ebx + 0xaa0], ecx
            //   e8????????           |                     

        $sequence_9 = { d3e0 488b4c2448 8b4c8c50 0bc8 8bc1 89442444 8b442420 }
            // n = 7, score = 400
            //   d3e0                 | dec                 eax
            //   488b4c2448           | sub                 esp, 0x40
            //   8b4c8c50             | dec                 eax
            //   0bc8                 | lea                 ebp, [edx + 0x80]
            //   8bc1                 | dec                 eax
            //   89442444             | cmp                 dword ptr [ebp + 0x3e8], 1
            //   8b442420             | je                  0x1562

    condition:
        7 of them and filesize < 4538368
}