rule win_sfile_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sfile."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sfile"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 8b4514 50 e8???????? 83c408 eb49 }
            // n = 6, score = 300
            //   52                   | push                edx
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   eb49                 | jmp                 0x4b

        $sequence_1 = { 8b55f8 2b55e8 d1fa 8955e4 8b45e4 }
            // n = 5, score = 300
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   2b55e8               | sub                 edx, dword ptr [ebp - 0x18]
            //   d1fa                 | sar                 edx, 1
            //   8955e4               | mov                 dword ptr [ebp - 0x1c], edx
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]

        $sequence_2 = { 8b55fc c7422000000000 8d45fc 50 }
            // n = 4, score = 300
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   c7422000000000       | mov                 dword ptr [edx + 0x20], 0
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax

        $sequence_3 = { 7433 6aff 8b4dfc 8b5118 52 }
            // n = 5, score = 300
            //   7433                 | je                  0x35
            //   6aff                 | push                -1
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b5118               | mov                 edx, dword ptr [ecx + 0x18]
            //   52                   | push                edx

        $sequence_4 = { 8b4818 51 ff15???????? 8b55fc 8b421c }
            // n = 5, score = 300
            //   8b4818               | mov                 ecx, dword ptr [eax + 0x18]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b421c               | mov                 eax, dword ptr [edx + 0x1c]

        $sequence_5 = { 8d8db8fdffff 51 e8???????? 83c41c 837dc800 7507 }
            // n = 6, score = 300
            //   8d8db8fdffff         | lea                 ecx, [ebp - 0x248]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   837dc800             | cmp                 dword ptr [ebp - 0x38], 0
            //   7507                 | jne                 9

        $sequence_6 = { 8b4244 8b4d08 8b5120 8b4008 }
            // n = 4, score = 300
            //   8b4244               | mov                 eax, dword ptr [edx + 0x44]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b5120               | mov                 edx, dword ptr [ecx + 0x20]
            //   8b4008               | mov                 eax, dword ptr [eax + 8]

        $sequence_7 = { 8b5158 52 e8???????? 83c404 8b4510 }
            // n = 5, score = 300
            //   8b5158               | mov                 edx, dword ptr [ecx + 0x58]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_8 = { 8b751c 8b4d20 f3a4 837d0802 }
            // n = 4, score = 300
            //   8b751c               | mov                 esi, dword ptr [ebp + 0x1c]
            //   8b4d20               | mov                 ecx, dword ptr [ebp + 0x20]
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   837d0802             | cmp                 dword ptr [ebp + 8], 2

        $sequence_9 = { 8bec 83ec2c 56 57 c745f400000000 }
            // n = 5, score = 300
            //   8bec                 | mov                 ebp, esp
            //   83ec2c               | sub                 esp, 0x2c
            //   56                   | push                esi
            //   57                   | push                edi
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0

    condition:
        7 of them and filesize < 588800
}