rule win_shadowhammer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.shadowhammer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.shadowhammer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 57 33f6 bfa8a24000 833cf55490400001 751d 8d04f550904000 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   33f6                 | xor                 esi, esi
            //   bfa8a24000           | mov                 edi, 0x40a2a8
            //   833cf55490400001     | cmp                 dword ptr [esi*8 + 0x409054], 1
            //   751d                 | jne                 0x1f
            //   8d04f550904000       | lea                 eax, [esi*8 + 0x409050]

        $sequence_1 = { 6a69 668945ae 58 6a49 59 6a44 }
            // n = 6, score = 100
            //   6a69                 | push                0x69
            //   668945ae             | mov                 word ptr [ebp - 0x52], ax
            //   58                   | pop                 eax
            //   6a49                 | push                0x49
            //   59                   | pop                 ecx
            //   6a44                 | push                0x44

        $sequence_2 = { 897e70 c686c800000043 c6864b01000043 c7466818934000 6a0d }
            // n = 5, score = 100
            //   897e70               | mov                 dword ptr [esi + 0x70], edi
            //   c686c800000043       | mov                 byte ptr [esi + 0xc8], 0x43
            //   c6864b01000043       | mov                 byte ptr [esi + 0x14b], 0x43
            //   c7466818934000       | mov                 dword ptr [esi + 0x68], 0x409318
            //   6a0d                 | push                0xd

        $sequence_3 = { 5f c3 56 8b35???????? 68287c4000 57 ffd6 }
            // n = 7, score = 100
            //   5f                   | pop                 edi
            //   c3                   | ret                 
            //   56                   | push                esi
            //   8b35????????         |                     
            //   68287c4000           | push                0x407c28
            //   57                   | push                edi
            //   ffd6                 | call                esi

        $sequence_4 = { c3 55 8bec 81ec4c030000 c785e4fcffff00b006c7 c785e8fcffffdab6ace6 c785ecfcffffc25c3799 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec4c030000         | sub                 esp, 0x34c
            //   c785e4fcffff00b006c7     | mov    dword ptr [ebp - 0x31c], 0xc706b000
            //   c785e8fcffffdab6ace6     | mov    dword ptr [ebp - 0x318], 0xe6acb6da
            //   c785ecfcffffc25c3799     | mov    dword ptr [ebp - 0x314], 0x99375cc2

        $sequence_5 = { 3d40984000 741b 3998b4000000 7513 50 e8???????? }
            // n = 6, score = 100
            //   3d40984000           | cmp                 eax, 0x409840
            //   741b                 | je                  0x1d
            //   3998b4000000         | cmp                 dword ptr [eax + 0xb4], ebx
            //   7513                 | jne                 0x15
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_6 = { ff45fc 8b45fc 3b45f4 7cb7 ebae 8b45f0 ebab }
            // n = 7, score = 100
            //   ff45fc               | inc                 dword ptr [ebp - 4]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   3b45f4               | cmp                 eax, dword ptr [ebp - 0xc]
            //   7cb7                 | jl                  0xffffffb9
            //   ebae                 | jmp                 0xffffffb0
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   ebab                 | jmp                 0xffffffad

        $sequence_7 = { 897e14 897e70 c686c800000043 c6864b01000043 c7466818934000 }
            // n = 5, score = 100
            //   897e14               | mov                 dword ptr [esi + 0x14], edi
            //   897e70               | mov                 dword ptr [esi + 0x70], edi
            //   c686c800000043       | mov                 byte ptr [esi + 0xc8], 0x43
            //   c6864b01000043       | mov                 byte ptr [esi + 0x14b], 0x43
            //   c7466818934000       | mov                 dword ptr [esi + 0x68], 0x409318

        $sequence_8 = { 817de00c714000 7311 8b45e0 8b00 85c0 7402 ffd0 }
            // n = 7, score = 100
            //   817de00c714000       | cmp                 dword ptr [ebp - 0x20], 0x40710c
            //   7311                 | jae                 0x13
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   85c0                 | test                eax, eax
            //   7402                 | je                  4
            //   ffd0                 | call                eax

        $sequence_9 = { 8b401c 8b08 3bc8 7439 }
            // n = 4, score = 100
            //   8b401c               | mov                 eax, dword ptr [eax + 0x1c]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   3bc8                 | cmp                 ecx, eax
            //   7439                 | je                  0x3b

    condition:
        7 of them and filesize < 49152
}