rule win_shadowpad_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.shadowpad."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.shadowpad"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf0 e8???????? 50 ffd7 8d75d0 8945ec }
            // n = 6, score = 200
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   8d75d0               | lea                 esi, [ebp - 0x30]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax

        $sequence_1 = { a80f 0f85c4000000 68f40f0000 8d45ec 50 8d4b0c }
            // n = 6, score = 200
            //   a80f                 | test                al, 0xf
            //   0f85c4000000         | jne                 0xca
            //   68f40f0000           | push                0xff4
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   8d4b0c               | lea                 ecx, [ebx + 0xc]

        $sequence_2 = { 3b450c 0f8d85000000 41 51 8d45e0 e8???????? }
            // n = 6, score = 200
            //   3b450c               | cmp                 eax, dword ptr [ebp + 0xc]
            //   0f8d85000000         | jge                 0x8b
            //   41                   | inc                 ecx
            //   51                   | push                ecx
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   e8????????           |                     

        $sequence_3 = { 53 56 33db 57 33d2 eb2d }
            // n = 6, score = 200
            //   53                   | push                ebx
            //   56                   | push                esi
            //   33db                 | xor                 ebx, ebx
            //   57                   | push                edi
            //   33d2                 | xor                 edx, edx
            //   eb2d                 | jmp                 0x2f

        $sequence_4 = { 894df8 890e 3803 7439 8b06 }
            // n = 5, score = 200
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   890e                 | mov                 dword ptr [esi], ecx
            //   3803                 | cmp                 byte ptr [ebx], al
            //   7439                 | je                  0x3b
            //   8b06                 | mov                 eax, dword ptr [esi]

        $sequence_5 = { 88144b 8a0408 8b560c c0e804 046a 88444a01 }
            // n = 6, score = 200
            //   88144b               | mov                 byte ptr [ebx + ecx*2], dl
            //   8a0408               | mov                 al, byte ptr [eax + ecx]
            //   8b560c               | mov                 edx, dword ptr [esi + 0xc]
            //   c0e804               | shr                 al, 4
            //   046a                 | add                 al, 0x6a
            //   88444a01             | mov                 byte ptr [edx + ecx*2 + 1], al

        $sequence_6 = { c20400 55 8bec 53 57 ff7508 ff15???????? }
            // n = 7, score = 200
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   53                   | push                ebx
            //   57                   | push                edi
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     

        $sequence_7 = { 8bec 51 8a4201 8845ff }
            // n = 4, score = 200
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   8a4201               | mov                 al, byte ptr [edx + 1]
            //   8845ff               | mov                 byte ptr [ebp - 1], al

        $sequence_8 = { 33c0 8d4de8 e8???????? 8b7de0 8bc3 50 }
            // n = 6, score = 200
            //   33c0                 | xor                 eax, eax
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   e8????????           |                     
            //   8b7de0               | mov                 edi, dword ptr [ebp - 0x20]
            //   8bc3                 | mov                 eax, ebx
            //   50                   | push                eax

        $sequence_9 = { 32d1 46 8810 3b7508 0f8c74ffffff 5f }
            // n = 6, score = 200
            //   32d1                 | xor                 dl, cl
            //   46                   | inc                 esi
            //   8810                 | mov                 byte ptr [eax], dl
            //   3b7508               | cmp                 esi, dword ptr [ebp + 8]
            //   0f8c74ffffff         | jl                  0xffffff7a
            //   5f                   | pop                 edi

    condition:
        7 of them and filesize < 188416
}