rule win_shady_hammock_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.shady_hammock."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.shady_hammock"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7203 488b01 488d0c10 488bfe 492bf9 4c8bc7 }
            // n = 6, score = 200
            //   7203                 | dec                 eax
            //   488b01               | mov                 ecx, ebx
            //   488d0c10             | dec                 eax
            //   488bfe               | mov                 edx, dword ptr [ebx]
            //   492bf9               | dec                 eax
            //   4c8bc7               | cmp                 eax, -1

        $sequence_1 = { 488bcd e8???????? 498d5701 41c6042c00 4881fa00100000 7218 }
            // n = 6, score = 200
            //   488bcd               | lea                 ecx, [0x3651e]
            //   e8????????           |                     
            //   498d5701             | dec                 esp
            //   41c6042c00           | lea                 eax, [esp + 0x20]
            //   4881fa00100000       | dec                 eax
            //   7218                 | mov                 dword ptr [ebx + 0x20], eax

        $sequence_2 = { e8???????? 4c8b5368 488d4d2f 48837d4710 0f93c2 480f434d2f 4c8b4d3f }
            // n = 7, score = 200
            //   e8????????           |                     
            //   4c8b5368             | dec                 eax
            //   488d4d2f             | mov                 dword ptr [edx + 0x18], 7
            //   48837d4710           | mov                 word ptr [edx], bp
            //   0f93c2               | dec                 eax
            //   480f434d2f           | cmp                 dword ptr [ecx + 0x20], ebp
            //   4c8b4d3f             | jne                 0xecc

        $sequence_3 = { 3bc7 0f843e010000 0fb6f8 e9???????? 0f57c0 }
            // n = 5, score = 200
            //   3bc7                 | mov                 word ptr [eax + ecx*2 + 2], di
            //   0f843e010000         | jmp                 0xbd3
            //   0fb6f8               | inc                 esp
            //   e9????????           |                     
            //   0f57c0               | mov                 al, byte ptr [ebp + 0x67]

        $sequence_4 = { 7453 488b5318 4883fa10 7205 488b0b }
            // n = 5, score = 200
            //   7453                 | dec                 eax
            //   488b5318             | mov                 dword ptr [edi], eax
            //   4883fa10             | dec                 eax
            //   7205                 | mov                 eax, edi
            //   488b0b               | movups              xmm0, xmmword ptr [ebx + 0x18]

        $sequence_5 = { 0bc1 89442408 0fae542408 c3 488bc4 53 }
            // n = 6, score = 200
            //   0bc1                 | lea                 eax, [edx + 1]
            //   89442408             | mov                 dword ptr [ebx + 4], eax
            //   0fae542408           | jmp                 0x4c3
            //   c3                   | dec                 ebx
            //   488bc4               | mov                 eax, dword ptr [ebx + edx*8 + 0x482c0]
            //   53                   | dec                 edx

        $sequence_6 = { 747e 8b82b0000000 4803c8 4903c9 4a8d1408 }
            // n = 5, score = 200
            //   747e                 | dec                 eax
            //   8b82b0000000         | mov                 eax, ebx
            //   4803c8               | dec                 eax
            //   4903c9               | add                 esp, 0x20
            //   4a8d1408             | pop                 ebx

        $sequence_7 = { 4883781810 7203 488b00 41b80a000000 488bd0 488bcf e8???????? }
            // n = 7, score = 200
            //   4883781810           | dec                 eax
            //   7203                 | mov                 edi, ecx
            //   488b00               | dec                 eax
            //   41b80a000000         | mov                 dword ptr [ecx], eax
            //   488bd0               | mov                 ebx, edx
            //   488bcf               | push                edi
            //   e8????????           |                     

        $sequence_8 = { eb2c 498bcf 488bc3 48d1e9 }
            // n = 4, score = 200
            //   eb2c                 | mov                 ecx, dword ptr [eax + edx*8]
            //   498bcf               | inc                 edx
            //   488bc3               | cmp                 byte ptr [ecx + ebp*8 + 0x38], bh
            //   48d1e9               | jge                 0x520

        $sequence_9 = { 48895c2408 4889742410 48897c2418 488bd9 4c8bc9 482b5a30 }
            // n = 6, score = 200
            //   48895c2408           | xor                 esi, esi
            //   4889742410           | dec                 eax
            //   48897c2418           | sub                 edi, eax
            //   488bd9               | vmovapd             xmm0, xmm1
            //   4c8bc9               | dec                 esp
            //   482b5a30             | lea                 ecx, [0x205c5]

    condition:
        7 of them and filesize < 635904
}