rule win_shakti_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.shakti."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.shakti"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 894df0 e9???????? 8b55fc 83c214 }
            // n = 4, score = 500
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   e9????????           |                     
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   83c214               | add                 edx, 0x14

        $sequence_1 = { 894dfc e9???????? 8b55f8 8b45d8 }
            // n = 4, score = 500
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   e9????????           |                     
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]

        $sequence_2 = { 8945ec 8b4dec 8b55c0 0311 8955d0 8b45d0 8b4dc0 }
            // n = 7, score = 500
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   8b55c0               | mov                 edx, dword ptr [ebp - 0x40]
            //   0311                 | add                 edx, dword ptr [ecx]
            //   8955d0               | mov                 dword ptr [ebp - 0x30], edx
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   8b4dc0               | mov                 ecx, dword ptr [ebp - 0x40]

        $sequence_3 = { 894dcc 8b55fc 83c208 8955f0 8b45cc }
            // n = 5, score = 500
            //   894dcc               | mov                 dword ptr [ebp - 0x34], ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   83c208               | add                 edx, 8
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]

        $sequence_4 = { 8b4de0 8b11 8955e0 e9???????? 8b45d8 }
            // n = 5, score = 500
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8955e0               | mov                 dword ptr [ebp - 0x20], edx
            //   e9????????           |                     
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]

        $sequence_5 = { 894df0 8b55fc 8b45d8 034210 8945e0 8b4de0 }
            // n = 6, score = 500
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]
            //   034210               | add                 eax, dword ptr [edx + 0x10]
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]

        $sequence_6 = { 0311 8b45e0 8910 eb1e 8b4de0 8b55d8 0311 }
            // n = 7, score = 500
            //   0311                 | add                 edx, dword ptr [ecx]
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8910                 | mov                 dword ptr [eax], edx
            //   eb1e                 | jmp                 0x20
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   8b55d8               | mov                 edx, dword ptr [ebp - 0x28]
            //   0311                 | add                 edx, dword ptr [ecx]

        $sequence_7 = { 8955f8 8b45f8 813850450000 7502 eb0b 8b4dc0 83e901 }
            // n = 7, score = 500
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   813850450000         | cmp                 dword ptr [eax], 0x4550
            //   7502                 | jne                 4
            //   eb0b                 | jmp                 0xd
            //   8b4dc0               | mov                 ecx, dword ptr [ebp - 0x40]
            //   83e901               | sub                 ecx, 1

        $sequence_8 = { ff75f4 8b35???????? ffd6 53 ff750c 8945f4 }
            // n = 6, score = 400
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   8b35????????         |                     
            //   ffd6                 | call                esi
            //   53                   | push                ebx
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax

        $sequence_9 = { 50 ff7594 e8???????? 2b7598 ff7598 }
            // n = 5, score = 400
            //   50                   | push                eax
            //   ff7594               | push                dword ptr [ebp - 0x6c]
            //   e8????????           |                     
            //   2b7598               | sub                 esi, dword ptr [ebp - 0x68]
            //   ff7598               | push                dword ptr [ebp - 0x68]

        $sequence_10 = { 8945f8 8b801c090000 8945fc ff75f8 68edacef0d 8b45fc ffd0 }
            // n = 7, score = 400
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b801c090000         | mov                 eax, dword ptr [eax + 0x91c]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   68edacef0d           | push                0xdefaced
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   ffd0                 | call                eax

        $sequence_11 = { 894810 894808 c3 56 }
            // n = 4, score = 400
            //   894810               | mov                 dword ptr [eax + 0x10], ecx
            //   894808               | mov                 dword ptr [eax + 8], ecx
            //   c3                   | ret                 
            //   56                   | push                esi

        $sequence_12 = { 3b1cfdb0a24000 7409 47 897dfc 83ff17 72ee 83ff17 }
            // n = 7, score = 400
            //   3b1cfdb0a24000       | cmp                 ebx, dword ptr [edi*8 + 0x40a2b0]
            //   7409                 | je                  0xb
            //   47                   | inc                 edi
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   83ff17               | cmp                 edi, 0x17
            //   72ee                 | jb                  0xfffffff0
            //   83ff17               | cmp                 edi, 0x17

        $sequence_13 = { 66837d6c01 7308 893d???????? eb14 8b07 a3???????? 833d????????ff }
            // n = 7, score = 400
            //   66837d6c01           | cmp                 word ptr [ebp + 0x6c], 1
            //   7308                 | jae                 0xa
            //   893d????????         |                     
            //   eb14                 | jmp                 0x16
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   a3????????           |                     
            //   833d????????ff       |                     

        $sequence_14 = { 83ec1c 53 8b1d???????? 85db 0f84dd000000 8d45e4 }
            // n = 6, score = 400
            //   83ec1c               | sub                 esp, 0x1c
            //   53                   | push                ebx
            //   8b1d????????         |                     
            //   85db                 | test                ebx, ebx
            //   0f84dd000000         | je                  0xe3
            //   8d45e4               | lea                 eax, [ebp - 0x1c]

        $sequence_15 = { 0f848a000000 ff750c 8d45f8 ff7508 8d4df0 e8???????? }
            // n = 6, score = 400
            //   0f848a000000         | je                  0x90
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 191488
}