rule win_shareip_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.shareip."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.shareip"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b02 8d8c2414010000 ffd0 83bc243001000000 7425 83bc242401000000 7412 }
            // n = 7, score = 100
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   8d8c2414010000       | lea                 ecx, [esp + 0x114]
            //   ffd0                 | call                eax
            //   83bc243001000000     | cmp                 dword ptr [esp + 0x130], 0
            //   7425                 | je                  0x27
            //   83bc242401000000     | cmp                 dword ptr [esp + 0x124], 0
            //   7412                 | je                  0x14

        $sequence_1 = { 56 894c2438 33d2 50 8d4c2440 895c2458 89742454 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   894c2438             | mov                 dword ptr [esp + 0x38], ecx
            //   33d2                 | xor                 edx, edx
            //   50                   | push                eax
            //   8d4c2440             | lea                 ecx, [esp + 0x40]
            //   895c2458             | mov                 dword ptr [esp + 0x58], ebx
            //   89742454             | mov                 dword ptr [esp + 0x54], esi

        $sequence_2 = { 83f8ff 7566 be10000000 39742444 720d 8b542430 52 }
            // n = 7, score = 100
            //   83f8ff               | cmp                 eax, -1
            //   7566                 | jne                 0x68
            //   be10000000           | mov                 esi, 0x10
            //   39742444             | cmp                 dword ptr [esp + 0x44], esi
            //   720d                 | jb                  0xf
            //   8b542430             | mov                 edx, dword ptr [esp + 0x30]
            //   52                   | push                edx

        $sequence_3 = { 8b7e10 8bcf 2b4d10 b867666666 f7e9 c1fa03 8bc2 }
            // n = 7, score = 100
            //   8b7e10               | mov                 edi, dword ptr [esi + 0x10]
            //   8bcf                 | mov                 ecx, edi
            //   2b4d10               | sub                 ecx, dword ptr [ebp + 0x10]
            //   b867666666           | mov                 eax, 0x66666667
            //   f7e9                 | imul                ecx
            //   c1fa03               | sar                 edx, 3
            //   8bc2                 | mov                 eax, edx

        $sequence_4 = { 8b542468 89542424 eb08 8d442468 89442424 39b424ec000000 720d }
            // n = 7, score = 100
            //   8b542468             | mov                 edx, dword ptr [esp + 0x68]
            //   89542424             | mov                 dword ptr [esp + 0x24], edx
            //   eb08                 | jmp                 0xa
            //   8d442468             | lea                 eax, [esp + 0x68]
            //   89442424             | mov                 dword ptr [esp + 0x24], eax
            //   39b424ec000000       | cmp                 dword ptr [esp + 0xec], esi
            //   720d                 | jb                  0xf

        $sequence_5 = { 8bc2 c1e81f 03c2 83f803 0f8557feffff 8d78ff 8d742414 }
            // n = 7, score = 100
            //   8bc2                 | mov                 eax, edx
            //   c1e81f               | shr                 eax, 0x1f
            //   03c2                 | add                 eax, edx
            //   83f803               | cmp                 eax, 3
            //   0f8557feffff         | jne                 0xfffffe5d
            //   8d78ff               | lea                 edi, [eax - 1]
            //   8d742414             | lea                 esi, [esp + 0x14]

        $sequence_6 = { 50 8d4c2420 51 8d5f20 c744243803000000 89542448 e8???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d4c2420             | lea                 ecx, [esp + 0x20]
            //   51                   | push                ecx
            //   8d5f20               | lea                 ebx, [edi + 0x20]
            //   c744243803000000     | mov                 dword ptr [esp + 0x38], 3
            //   89542448             | mov                 dword ptr [esp + 0x48], edx
            //   e8????????           |                     

        $sequence_7 = { 8d442408 8da42400000000 8a10 3a11 751a 84d2 }
            // n = 6, score = 100
            //   8d442408             | lea                 eax, [esp + 8]
            //   8da42400000000       | lea                 esp, [esp]
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   3a11                 | cmp                 dl, byte ptr [ecx]
            //   751a                 | jne                 0x1c
            //   84d2                 | test                dl, dl

        $sequence_8 = { 8b01 8d7001 8a10 40 84d2 75f9 2bc6 }
            // n = 7, score = 100
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8d7001               | lea                 esi, [eax + 1]
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   40                   | inc                 eax
            //   84d2                 | test                dl, dl
            //   75f9                 | jne                 0xfffffffb
            //   2bc6                 | sub                 eax, esi

        $sequence_9 = { 8bce bb03000000 e8???????? eb02 33c0 c78424b000000002000000 8907 }
            // n = 7, score = 100
            //   8bce                 | mov                 ecx, esi
            //   bb03000000           | mov                 ebx, 3
            //   e8????????           |                     
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   c78424b000000002000000     | mov    dword ptr [esp + 0xb0], 2
            //   8907                 | mov                 dword ptr [edi], eax

    condition:
        7 of them and filesize < 811008
}