rule win_sharpknot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sharpknot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sharpknot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8d8c246c020000 c7842498050000ffffffff e8???????? 8b8c2490050000 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   8d8c246c020000       | lea                 ecx, [esp + 0x26c]
            //   c7842498050000ffffffff     | mov    dword ptr [esp + 0x598], 0xffffffff
            //   e8????????           |                     
            //   8b8c2490050000       | mov                 ecx, dword ptr [esp + 0x590]

        $sequence_1 = { 8d542420 8bcf b8abaaaa2a 2bcd 52 f7e9 c1fa02 }
            // n = 7, score = 100
            //   8d542420             | lea                 edx, [esp + 0x20]
            //   8bcf                 | mov                 ecx, edi
            //   b8abaaaa2a           | mov                 eax, 0x2aaaaaab
            //   2bcd                 | sub                 ecx, ebp
            //   52                   | push                edx
            //   f7e9                 | imul                ecx
            //   c1fa02               | sar                 edx, 2

        $sequence_2 = { 8bca 897c2430 c1e91f 03d1 83fa01 0f83b3000000 8bcb }
            // n = 7, score = 100
            //   8bca                 | mov                 ecx, edx
            //   897c2430             | mov                 dword ptr [esp + 0x30], edi
            //   c1e91f               | shr                 ecx, 0x1f
            //   03d1                 | add                 edx, ecx
            //   83fa01               | cmp                 edx, 1
            //   0f83b3000000         | jae                 0xb9
            //   8bcb                 | mov                 ecx, ebx

        $sequence_3 = { e8???????? 8b8c2490050000 5f 5e 5d 33c0 5b }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b8c2490050000       | mov                 ecx, dword ptr [esp + 0x590]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   33c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx

        $sequence_4 = { 8a8681f84400 2410 3c10 7508 660fb6b680f74400 }
            // n = 5, score = 100
            //   8a8681f84400         | mov                 al, byte ptr [esi + 0x44f881]
            //   2410                 | and                 al, 0x10
            //   3c10                 | cmp                 al, 0x10
            //   7508                 | jne                 0xa
            //   660fb6b680f74400     | movzx               si, byte ptr [esi + 0x44f780]

        $sequence_5 = { 7f08 81f90000a000 7616 6800001000 8d542414 6a01 }
            // n = 6, score = 100
            //   7f08                 | jg                  0xa
            //   81f90000a000         | cmp                 ecx, 0xa00000
            //   7616                 | jbe                 0x18
            //   6800001000           | push                0x100000
            //   8d542414             | lea                 edx, [esp + 0x14]
            //   6a01                 | push                1

        $sequence_6 = { 51 e8???????? 89442448 89442428 8b44243c 895c2434 8954244c }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   e8????????           |                     
            //   89442448             | mov                 dword ptr [esp + 0x48], eax
            //   89442428             | mov                 dword ptr [esp + 0x28], eax
            //   8b44243c             | mov                 eax, dword ptr [esp + 0x3c]
            //   895c2434             | mov                 dword ptr [esp + 0x34], ebx
            //   8954244c             | mov                 dword ptr [esp + 0x4c], edx

        $sequence_7 = { 7522 8d44240c 50 e8???????? 8bf0 83c408 85f6 }
            // n = 7, score = 100
            //   7522                 | jne                 0x24
            //   8d44240c             | lea                 eax, [esp + 0xc]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c408               | add                 esp, 8
            //   85f6                 | test                esi, esi

        $sequence_8 = { f3a4 b910000000 8d7c2414 f3ab 8d442454 8d4c2410 50 }
            // n = 7, score = 100
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   b910000000           | mov                 ecx, 0x10
            //   8d7c2414             | lea                 edi, [esp + 0x14]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8d442454             | lea                 eax, [esp + 0x54]
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   50                   | push                eax

        $sequence_9 = { 8b520c 52 e8???????? 83c404 }
            // n = 4, score = 100
            //   8b520c               | mov                 edx, dword ptr [edx + 0xc]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

    condition:
        7 of them and filesize < 1032192
}