rule win_shatteredglass_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.shatteredglass."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.shatteredglass"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 03f0 83fe10 7ce1 83fe10 752f }
            // n = 5, score = 100
            //   03f0                 | add                 esi, eax
            //   83fe10               | cmp                 esi, 0x10
            //   7ce1                 | jl                  0xffffffe3
            //   83fe10               | cmp                 esi, 0x10
            //   752f                 | jne                 0x31

        $sequence_1 = { 7ce1 83fe10 752f eb29 }
            // n = 4, score = 100
            //   7ce1                 | jl                  0xffffffe3
            //   83fe10               | cmp                 esi, 0x10
            //   752f                 | jne                 0x31
            //   eb29                 | jmp                 0x2b

        $sequence_2 = { 0f8ecf000000 8b531c 8bca 8d7102 }
            // n = 4, score = 100
            //   0f8ecf000000         | jle                 0xd5
            //   8b531c               | mov                 edx, dword ptr [ebx + 0x1c]
            //   8bca                 | mov                 ecx, edx
            //   8d7102               | lea                 esi, [ecx + 2]

        $sequence_3 = { 6a00 b810000000 2bc6 50 8d8640d74100 50 57 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   b810000000           | mov                 eax, 0x10
            //   2bc6                 | sub                 eax, esi
            //   50                   | push                eax
            //   8d8640d74100         | lea                 eax, [esi + 0x41d740]
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_4 = { eb02 32d2 8bc6 c0e104 d1e8 02ca 83c602 }
            // n = 7, score = 100
            //   eb02                 | jmp                 4
            //   32d2                 | xor                 dl, dl
            //   8bc6                 | mov                 eax, esi
            //   c0e104               | shl                 cl, 4
            //   d1e8                 | shr                 eax, 1
            //   02ca                 | add                 cl, dl
            //   83c602               | add                 esi, 2

        $sequence_5 = { 8d4900 0fb70c77 8d41d0 6683f809 7705 }
            // n = 5, score = 100
            //   8d4900               | lea                 ecx, [ecx]
            //   0fb70c77             | movzx               ecx, word ptr [edi + esi*2]
            //   8d41d0               | lea                 eax, [ecx - 0x30]
            //   6683f809             | cmp                 ax, 9
            //   7705                 | ja                  7

        $sequence_6 = { 7705 80e937 eb10 8d419f 6683f819 7705 }
            // n = 6, score = 100
            //   7705                 | ja                  7
            //   80e937               | sub                 cl, 0x37
            //   eb10                 | jmp                 0x12
            //   8d419f               | lea                 eax, [ecx - 0x61]
            //   6683f819             | cmp                 ax, 0x19
            //   7705                 | ja                  7

        $sequence_7 = { 53 ff15???????? 80bd33ffffff00 0f8452ffffff 57 e8???????? }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   80bd33ffffff00       | cmp                 byte ptr [ebp - 0xcd], 0
            //   0f8452ffffff         | je                  0xffffff58
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_8 = { 2bce d1f9 83f918 740a 68???????? e9???????? }
            // n = 6, score = 100
            //   2bce                 | sub                 ecx, esi
            //   d1f9                 | sar                 ecx, 1
            //   83f918               | cmp                 ecx, 0x18
            //   740a                 | je                  0xc
            //   68????????           |                     
            //   e9????????           |                     

        $sequence_9 = { 72f1 33c0 5d c3 8b04c58c434100 5d c3 }
            // n = 7, score = 100
            //   72f1                 | jb                  0xfffffff3
            //   33c0                 | xor                 eax, eax
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b04c58c434100       | mov                 eax, dword ptr [eax*8 + 0x41438c]
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

    condition:
        7 of them and filesize < 273408
}