rule win_shifu_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.shifu."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.shifu"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 895dfc 6a08 58 e8???????? 8bc4 85c0 7411 }
            // n = 7, score = 100
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   6a08                 | push                8
            //   58                   | pop                 eax
            //   e8????????           |                     
            //   8bc4                 | mov                 eax, esp
            //   85c0                 | test                eax, eax
            //   7411                 | je                  0x13

        $sequence_1 = { 56 e8???????? 85c0 0f848d010000 ff7508 683a041000 e8???????? }
            // n = 7, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f848d010000         | je                  0x193
            //   ff7508               | push                dword ptr [ebp + 8]
            //   683a041000           | push                0x10043a
            //   e8????????           |                     

        $sequence_2 = { 83c420 f644242010 741c 6a04 6a00 ff742418 e8???????? }
            // n = 7, score = 100
            //   83c420               | add                 esp, 0x20
            //   f644242010           | test                byte ptr [esp + 0x20], 0x10
            //   741c                 | je                  0x1e
            //   6a04                 | push                4
            //   6a00                 | push                0
            //   ff742418             | push                dword ptr [esp + 0x18]
            //   e8????????           |                     

        $sequence_3 = { 83c604 833e00 75a3 83c714 8b470c 85c0 0f8573ffffff }
            // n = 7, score = 100
            //   83c604               | add                 esi, 4
            //   833e00               | cmp                 dword ptr [esi], 0
            //   75a3                 | jne                 0xffffffa5
            //   83c714               | add                 edi, 0x14
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   85c0                 | test                eax, eax
            //   0f8573ffffff         | jne                 0xffffff79

        $sequence_4 = { 6800200000 57 57 6a02 ff15???????? 8bd8 3bdf }
            // n = 7, score = 100
            //   6800200000           | push                0x2000
            //   57                   | push                edi
            //   57                   | push                edi
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   3bdf                 | cmp                 ebx, edi

        $sequence_5 = { 7516 6aff 53 ff15???????? 83f8ff 7408 53 }
            // n = 7, score = 100
            //   7516                 | jne                 0x18
            //   6aff                 | push                -1
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   83f8ff               | cmp                 eax, -1
            //   7408                 | je                  0xa
            //   53                   | push                ebx

        $sequence_6 = { 85c0 7540 3945f4 7447 ff15???????? 8b75f8 8365f400 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7540                 | jne                 0x42
            //   3945f4               | cmp                 dword ptr [ebp - 0xc], eax
            //   7447                 | je                  0x49
            //   ff15????????         |                     
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]
            //   8365f400             | and                 dword ptr [ebp - 0xc], 0

        $sequence_7 = { 50 68060000c8 56 c7442430b907a225 c744243660468ee9 c744243a76e58c74 66c744243e063e }
            // n = 7, score = 100
            //   50                   | push                eax
            //   68060000c8           | push                0xc8000006
            //   56                   | push                esi
            //   c7442430b907a225     | mov                 dword ptr [esp + 0x30], 0x25a207b9
            //   c744243660468ee9     | mov                 dword ptr [esp + 0x36], 0xe98e4660
            //   c744243a76e58c74     | mov                 dword ptr [esp + 0x3a], 0x748ce576
            //   66c744243e063e       | mov                 word ptr [esp + 0x3e], 0x3e06

        $sequence_8 = { 50 ff15???????? 6a10 58 e8???????? 8bc4 3bc7 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   6a10                 | push                0x10
            //   58                   | pop                 eax
            //   e8????????           |                     
            //   8bc4                 | mov                 eax, esp
            //   3bc7                 | cmp                 eax, edi

        $sequence_9 = { e8???????? 50 ffd6 893d???????? 3bc7 740a c705????????01000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   893d????????         |                     
            //   3bc7                 | cmp                 eax, edi
            //   740a                 | je                  0xc
            //   c705????????01000000     |     

    condition:
        7 of them and filesize < 344064
}