rule win_shrinklocker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.shrinklocker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.shrinklocker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { a804 7409 488d1db94c0300 eb14 a802 488d1dc64c0300 488d05d74c0300 }
            // n = 7, score = 100
            //   a804                 | jne                 0x5e6
            //   7409                 | inc                 ebp
            //   488d1db94c0300       | xor                 esp, esp
            //   eb14                 | dec                 eax
            //   a802                 | add                 esi, eax
            //   488d1dc64c0300       | dec                 esp
            //   488d05d74c0300       | cmp                 dword ptr [ecx], esp

        $sequence_1 = { 4803c8 488bc1 488b4d20 488b95d8000000 488d0c51 4c8bc0 488b4538 }
            // n = 7, score = 100
            //   4803c8               | dec                 eax
            //   488bc1               | lea                 edi, [0x23b6b]
            //   488b4d20             | jmp                 0xaf0
            //   488b95d8000000       | dec                 eax
            //   488d0c51             | lea                 edi, [0x23b72]
            //   4c8bc0               | jmp                 0xaf0
            //   488b4538             | dec                 eax

        $sequence_2 = { 488b4c2460 898110170000 e9???????? 8b442468 ffc8 488b4c2460 4881c1bc000000 }
            // n = 7, score = 100
            //   488b4c2460           | inc                 ebp
            //   898110170000         | xor                 esp, esp
            //   e9????????           |                     
            //   8b442468             | inc                 esp
            //   ffc8                 | cmp                 byte ptr [ebp - 0x40], ah
            //   488b4c2460           | jne                 0xe9
            //   4881c1bc000000       | dec                 esp

        $sequence_3 = { 4c896310 4d8bc6 48897318 488bcf 4883fd0f 7648 488b33 }
            // n = 7, score = 100
            //   4c896310             | mov                 dword ptr [esp + 0x20], eax
            //   4d8bc6               | mov                 dword ptr [esp + 0x28], 0
            //   48897318             | dec                 eax
            //   488bcf               | lea                 eax, [esp + 0x140]
            //   4883fd0f             | dec                 eax
            //   7648                 | mov                 dword ptr [esp + 0x20], eax
            //   488b33               | inc                 ecx

        $sequence_4 = { e8???????? 488b4c2430 48894c2420 4c8b4c2458 4c8b442460 488b4c2450 488b5110 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b4c2430           | dec                 eax
            //   48894c2420           | mov                 eax, dword ptr [esp + 0x58]
            //   4c8b4c2458           | dec                 eax
            //   4c8b442460           | mov                 ecx, dword ptr [esp + 0x28]
            //   488b4c2450           | dec                 eax
            //   488b5110             | sub                 ecx, eax

        $sequence_5 = { e8???????? 88442425 488b8c2480000000 488b09 48634904 488b942480000000 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   88442425             | mov                 ecx, dword ptr [esp + 0x20]
            //   488b8c2480000000     | movzx               edx, word ptr [esp]
            //   488b09               | mov                 word ptr [ecx + eax*4 + 2], dx
            //   48634904             | dec                 eax
            //   488b942480000000     | mov                 ecx, dword ptr [esp + 0x60]

        $sequence_6 = { eb58 b804000000 4869c000010000 488b4c2468 0fb70401 488b4c2460 8b8910170000 }
            // n = 7, score = 100
            //   eb58                 | mov                 dword ptr [esp + 8], ecx
            //   b804000000           | dec                 eax
            //   4869c000010000       | sub                 esp, 0x38
            //   488b4c2468           | dec                 eax
            //   0fb70401             | mov                 eax, dword ptr [esp + 0x40]
            //   488b4c2460           | dec                 eax
            //   8b8910170000         | mov                 dword ptr [esp + 0x28], eax

        $sequence_7 = { 8b84815c270100 4803c1 ffe0 488b442430 83781000 7511 }
            // n = 6, score = 100
            //   8b84815c270100       | inc                 eax
            //   4803c1               | dec                 eax
            //   ffe0                 | mov                 ecx, dword ptr [esp + 0x48]
            //   488b442430           | dec                 eax
            //   83781000             | mov                 dword ptr [ecx], eax
            //   7511                 | dec                 eax

        $sequence_8 = { 2500e00000 85c0 7424 488b842410010000 488d0de2300400 48894820 488b442430 }
            // n = 7, score = 100
            //   2500e00000           | lea                 ecx, [esp + 0x1b8]
            //   85c0                 | dec                 eax
            //   7424                 | mov                 ecx, edx
            //   488b842410010000     | dec                 esp
            //   488d0de2300400       | mov                 ecx, eax
            //   48894820             | dec                 esp
            //   488b442430           | mov                 eax, ecx

        $sequence_9 = { 488d54242f 488d4c2458 e8???????? 90 c644243011 488d542430 488d4c2458 }
            // n = 7, score = 100
            //   488d54242f           | dec                 eax
            //   488d4c2458           | mov                 dword ptr [esp + 0x38], eax
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   c644243011           | lea                 ecx, [esp + 0x48]
            //   488d542430           | dec                 eax
            //   488d4c2458           | mov                 eax, dword ptr [esp + 0x38]

    condition:
        7 of them and filesize < 10490880
}