rule win_shujin_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.shujin."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.shujin"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff35???????? 8f442404 68dd5d08ae 60 ff3424 }
            // n = 5, score = 100
            //   ff35????????         |                     
            //   8f442404             | pop                 dword ptr [esp + 4]
            //   68dd5d08ae           | push                0xae085ddd
            //   60                   | pushal              
            //   ff3424               | push                dword ptr [esp]

        $sequence_1 = { 56 68???????? 53 53 ff15???????? 8984bdfcfeffff 47 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   68????????           |                     
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8984bdfcfeffff       | mov                 dword ptr [ebp + edi*4 - 0x104], eax
            //   47                   | inc                 edi

        $sequence_2 = { 660fa3ff f8 3529af0800 9c c7858cfcffffcccccccc 9c f8 }
            // n = 7, score = 100
            //   660fa3ff             | bt                  di, di
            //   f8                   | clc                 
            //   3529af0800           | xor                 eax, 0x8af29
            //   9c                   | pushfd              
            //   c7858cfcffffcccccccc     | mov    dword ptr [ebp - 0x374], 0xcccccccc
            //   9c                   | pushfd              
            //   f8                   | clc                 

        $sequence_3 = { 6814050000 53 68???????? e8???????? 83c40c 891d???????? }
            // n = 6, score = 100
            //   6814050000           | push                0x514
            //   53                   | push                ebx
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   891d????????         |                     

        $sequence_4 = { 8b742410 57 6a08 5f 8b4cfe50 }
            // n = 5, score = 100
            //   8b742410             | mov                 esi, dword ptr [esp + 0x10]
            //   57                   | push                edi
            //   6a08                 | push                8
            //   5f                   | pop                 edi
            //   8b4cfe50             | mov                 ecx, dword ptr [esi + edi*8 + 0x50]

        $sequence_5 = { c1ea02 8a92506c4000 8811 83e003 c1e004 8bd6 c1ea04 }
            // n = 7, score = 100
            //   c1ea02               | shr                 edx, 2
            //   8a92506c4000         | mov                 dl, byte ptr [edx + 0x406c50]
            //   8811                 | mov                 byte ptr [ecx], dl
            //   83e003               | and                 eax, 3
            //   c1e004               | shl                 eax, 4
            //   8bd6                 | mov                 edx, esi
            //   c1ea04               | shr                 edx, 4

        $sequence_6 = { 8bda 23d8 0fb69be8a54000 33fb 8b5d08 337b04 8b5d0c }
            // n = 7, score = 100
            //   8bda                 | mov                 ebx, edx
            //   23d8                 | and                 ebx, eax
            //   0fb69be8a54000       | movzx               ebx, byte ptr [ebx + 0x40a5e8]
            //   33fb                 | xor                 edi, ebx
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   337b04               | xor                 edi, dword ptr [ebx + 4]
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]

        $sequence_7 = { c0f305 f9 6a04 87ce 9c 0fbec9 660face902 }
            // n = 7, score = 100
            //   c0f305               | sal                 bl, 5
            //   f9                   | stc                 
            //   6a04                 | push                4
            //   87ce                 | xchg                esi, ecx
            //   9c                   | pushfd              
            //   0fbec9               | movsx               ecx, cl
            //   660face902           | shrd                cx, bp, 2

        $sequence_8 = { 885c2404 887c2404 8d642410 e8???????? 9c 668b3424 }
            // n = 6, score = 100
            //   885c2404             | mov                 byte ptr [esp + 4], bl
            //   887c2404             | mov                 byte ptr [esp + 4], bh
            //   8d642410             | lea                 esp, [esp + 0x10]
            //   e8????????           |                     
            //   9c                   | pushfd              
            //   668b3424             | mov                 si, word ptr [esp]

        $sequence_9 = { 8d45ec 50 68000f0050 8d8e74040000 57 e8???????? 6a05 }
            // n = 7, score = 100
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   68000f0050           | push                0x50000f00
            //   8d8e74040000         | lea                 ecx, [esi + 0x474]
            //   57                   | push                edi
            //   e8????????           |                     
            //   6a05                 | push                5

    condition:
        7 of them and filesize < 172032
}