rule win_shylock_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.shylock."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.shylock"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? eb75 8d75d0 e8???????? 8d75a4 e8???????? 8d75c4 }
            // n = 7, score = 500
            //   e8????????           |                     
            //   eb75                 | jmp                 0x77
            //   8d75d0               | lea                 esi, [ebp - 0x30]
            //   e8????????           |                     
            //   8d75a4               | lea                 esi, [ebp - 0x5c]
            //   e8????????           |                     
            //   8d75c4               | lea                 esi, [ebp - 0x3c]

        $sequence_1 = { c20800 55 8bec 83ec1c 56 8d45ec 57 }
            // n = 7, score = 500
            //   c20800               | ret                 8
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec1c               | sub                 esp, 0x1c
            //   56                   | push                esi
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   57                   | push                edi

        $sequence_2 = { ff75e0 e8???????? 83c410 33c0 eb0c b857000780 eb05 }
            // n = 7, score = 500
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   33c0                 | xor                 eax, eax
            //   eb0c                 | jmp                 0xe
            //   b857000780           | mov                 eax, 0x80070057
            //   eb05                 | jmp                 7

        $sequence_3 = { ff75b8 53 e8???????? 83c420 85c0 7439 3975fc }
            // n = 7, score = 500
            //   ff75b8               | push                dword ptr [ebp - 0x48]
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c420               | add                 esp, 0x20
            //   85c0                 | test                eax, eax
            //   7439                 | je                  0x3b
            //   3975fc               | cmp                 dword ptr [ebp - 4], esi

        $sequence_4 = { e8???????? 59 85c0 751a e8???????? 3db7000000 740e }
            // n = 7, score = 500
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   751a                 | jne                 0x1c
            //   e8????????           |                     
            //   3db7000000           | cmp                 eax, 0xb7
            //   740e                 | je                  0x10

        $sequence_5 = { e8???????? 59 50 ff750c ff7508 e8???????? 8d751c }
            // n = 7, score = 500
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   50                   | push                eax
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   8d751c               | lea                 esi, [ebp + 0x1c]

        $sequence_6 = { ff75f8 e8???????? 8d45f0 50 8bc6 8b7508 50 }
            // n = 7, score = 500
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   e8????????           |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   8bc6                 | mov                 eax, esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   50                   | push                eax

        $sequence_7 = { 8d75fc e8???????? 6a00 68???????? 8d5d0c e8???????? 6a00 }
            // n = 7, score = 500
            //   8d75fc               | lea                 esi, [ebp - 4]
            //   e8????????           |                     
            //   6a00                 | push                0
            //   68????????           |                     
            //   8d5d0c               | lea                 ebx, [ebp + 0xc]
            //   e8????????           |                     
            //   6a00                 | push                0

        $sequence_8 = { eb06 8b4d20 8d3488 e8???????? 8b75f0 8d7ddc e8???????? }
            // n = 7, score = 500
            //   eb06                 | jmp                 8
            //   8b4d20               | mov                 ecx, dword ptr [ebp + 0x20]
            //   8d3488               | lea                 esi, [eax + ecx*4]
            //   e8????????           |                     
            //   8b75f0               | mov                 esi, dword ptr [ebp - 0x10]
            //   8d7ddc               | lea                 edi, [ebp - 0x24]
            //   e8????????           |                     

        $sequence_9 = { ff75f0 e8???????? 8b5d0c 8d45d0 50 e8???????? 8bd8 }
            // n = 7, score = 500
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   e8????????           |                     
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax

    condition:
        7 of them and filesize < 630784
}