rule win_sidetwist_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sidetwist."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sidetwist"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4183fd10 0f94c0 4585ff 0f94c2 08d0 0f84ba080000 4531f6 }
            // n = 7, score = 100
            //   4183fd10             | dec                 eax
            //   0f94c0               | lea                 edx, [0x4181c]
            //   4585ff               | inc                 ecx
            //   0f94c2               | pop                 esp
            //   08d0                 | ret                 
            //   0f84ba080000         | dec                 eax
            //   4531f6               | mov                 ebp, eax

        $sequence_1 = { 48c744246000000000 4183fc0a 0f8e3efbffff bbffffffff e9???????? 488b03 4889d9 }
            // n = 7, score = 100
            //   48c744246000000000     | dec    eax
            //   4183fc0a             | mov                 dword ptr [ecx], eax
            //   0f8e3efbffff         | dec                 eax
            //   bbffffffff           | mov                 ebx, ecx
            //   e9????????           |                     
            //   488b03               | je                  0x6e6
            //   4889d9               | dec                 eax

        $sequence_2 = { 4839d0 0f8350010000 4883c001 c7442468ffffffff 48894310 c644244600 }
            // n = 6, score = 100
            //   4839d0               | dec                 eax
            //   0f8350010000         | lea                 ebp, [esp + 0x68]
            //   4883c001             | inc                 eax
            //   c7442468ffffffff     | movsx               edx, bh
            //   48894310             | dec                 eax
            //   c644244600           | mov                 ecx, ebp

        $sequence_3 = { 4889c3 488d8570ffffff 4889c1 e8???????? 488d55db 4989d0 4889da }
            // n = 7, score = 100
            //   4889c3               | dec                 eax
            //   488d8570ffffff       | mov                 ecx, eax
            //   4889c1               | dec                 eax
            //   e8????????           |                     
            //   488d55db             | mov                 ecx, eax
            //   4989d0               | dec                 eax
            //   4889da               | mov                 dword ptr [ebp - 0x18], eax

        $sequence_4 = { 660fefc0 48c783e000000000000000 668983e8000000 488d05b87f0500 0f1183f0000000 488d48d8 66480f6ec8 }
            // n = 7, score = 100
            //   660fefc0             | movups              xmmword ptr [ebx + 0x60], xmm0
            //   48c783e000000000000000     | pxor    xmm0, xmm0
            //   668983e8000000       | movups              xmmword ptr [ebx + 0x88], xmm0
            //   488d05b87f0500       | dec                 eax
            //   0f1183f0000000       | mov                 dword ptr [ebx - 8], 0
            //   488d48d8             | dec                 eax
            //   66480f6ec8           | mov                 dword ptr [ebx], eax

        $sequence_5 = { 488d5c2420 488d15ea540b00 4889d9 448d4001 e8???????? 4889d9 e8???????? }
            // n = 7, score = 100
            //   488d5c2420           | add                 esp, 0x20
            //   488d15ea540b00       | pop                 ebx
            //   4889d9               | dec                 eax
            //   448d4001             | lea                 eax, [0x3e4a0]
            //   e8????????           |                     
            //   4889d9               | xor                 edx, edx
            //   e8????????           |                     

        $sequence_6 = { 4889442448 4c8b70e8 48b8fcffffffffffff3f 4c39f0 0f8247050000 4b8d0c36 }
            // n = 6, score = 100
            //   4889442448           | cmp                 bh, al
            //   4c8b70e8             | jne                 0x23a
            //   48b8fcffffffffffff3f     | dec    eax
            //   4c39f0               | mov                 eax, dword ptr [esp + 0x78]
            //   0f8247050000         | dec                 eax
            //   4b8d0c36             | cmp                 dword ptr [eax - 0x18], 0

        $sequence_7 = { 410fb65601 38c2 7448 41807c243800 0f85e3feffff ba58000000 4c89e1 }
            // n = 7, score = 100
            //   410fb65601           | dec                 eax
            //   38c2                 | mov                 edi, edx
            //   7448                 | dec                 esp
            //   41807c243800         | mov                 esi, eax
            //   0f85e3feffff         | dec                 eax
            //   ba58000000           | test                ecx, ecx
            //   4c89e1               | je                  0x509

        $sequence_8 = { 488b4520 c640506e 488b4520 c640516e 488b4520 c6405265 488d45e0 }
            // n = 7, score = 100
            //   488b4520             | add                 eax, 0x10
            //   c640506e             | dec                 esp
            //   488b4520             | lea                 eax, [0x1de99]
            //   c640516e             | dec                 eax
            //   488b4520             | mov                 ecx, ebx
            //   c6405265             | dec                 eax
            //   488d45e0             | add                 eax, 0x10

        $sequence_9 = { 488b4520 c640486e 488b4520 c640496f 488b4520 c6404a74 488b4520 }
            // n = 7, score = 100
            //   488b4520             | mov                 ecx, ebx
            //   c640486e             | dec                 eax
            //   488b4520             | add                 eax, 0x10
            //   c640496f             | dec                 esp
            //   488b4520             | lea                 eax, [0x1d928]
            //   c6404a74             | dec                 eax
            //   488b4520             | mov                 ecx, ebx

    condition:
        7 of them and filesize < 2002944
}