rule win_sidewalk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sidewalk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sidewalk"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 41c1c610 4503e6 4403cb 4533d1 4403ee 41c1c210 418bc3 }
            // n = 7, score = 200
            //   41c1c610             | add                 esp, esi
            //   4503e6               | inc                 esp
            //   4403cb               | add                 ecx, ebx
            //   4533d1               | inc                 esp
            //   4403ee               | xor                 esi, edx
            //   41c1c210             | rol                 edi, 0x10
            //   418bc3               | inc                 esp

        $sequence_1 = { c1c010 4403d8 4133db c1c30c }
            // n = 4, score = 200
            //   c1c010               | jne                 0x13
            //   4403d8               | dec                 eax
            //   4133db               | mov                 ecx, edi
            //   c1c30c               | inc                 esp

        $sequence_2 = { ff15???????? 4885c0 750e 488bcf ff15???????? }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   4885c0               | dec                 eax
            //   750e                 | test                eax, eax
            //   488bcf               | jne                 0x10
            //   ff15????????         |                     

        $sequence_3 = { 33f0 418bc1 4133c6 c1c608 c1c010 4403de 4403e8 }
            // n = 7, score = 200
            //   33f0                 | add                 ebx, edi
            //   418bc1               | inc                 ecx
            //   4133c6               | rol                 esi, 0x10
            //   c1c608               | inc                 ebp
            //   c1c010               | add                 esp, esi
            //   4403de               | rol                 eax, 0x10
            //   4403e8               | inc                 esp

        $sequence_4 = { 4433f2 c1c710 4403df 41c1c610 4503e6 4403cb }
            // n = 6, score = 200
            //   4433f2               | dec                 eax
            //   c1c710               | mov                 ecx, edi
            //   4403df               | dec                 eax
            //   41c1c610             | test                eax, eax
            //   4503e6               | jne                 0x10
            //   4403cb               | dec                 eax

        $sequence_5 = { c1e810 880a c1e918 884202 884a03 4183f810 }
            // n = 6, score = 200
            //   c1e810               | add                 ebx, eax
            //   880a                 | inc                 ecx
            //   c1e918               | xor                 ebx, ebx
            //   884202               | rol                 ebx, 0xc
            //   884a03               | rol                 esi, 8
            //   4183f810             | rol                 eax, 0x10

        $sequence_6 = { 48ffc1 488d040a 483bc6 7ce2 }
            // n = 4, score = 200
            //   48ffc1               | inc                 ecx
            //   488d040a             | xor                 ebx, ebx
            //   483bc6               | rol                 ebx, 0xc
            //   7ce2                 | add                 edx, ebx

        $sequence_7 = { 4133db c1c30c 03d3 8bf2 }
            // n = 4, score = 200
            //   4133db               | inc                 ecx
            //   c1c30c               | mov                 eax, ecx
            //   03d3                 | inc                 ecx
            //   8bf2                 | xor                 eax, esi

        $sequence_8 = { 4133db 418bcd c1c307 4133c8 }
            // n = 4, score = 200
            //   4133db               | inc                 ecx
            //   418bcd               | xor                 edi, eax
            //   c1c307               | rol                 esi, 0x10
            //   4133c8               | inc                 esp

        $sequence_9 = { 418b09 418bc0 c1e002 4d8d4904 4863d0 }
            // n = 5, score = 200
            //   418b09               | add                 edx, ebx
            //   418bc0               | mov                 esi, edx
            //   c1e002               | xor                 eax, esi
            //   4d8d4904             | rol                 eax, 0x10
            //   4863d0               | inc                 esp

        $sequence_10 = { 8a040f 3201 41880408 48ffc1 488d040a }
            // n = 5, score = 200
            //   8a040f               | mov                 eax, edi
            //   3201                 | xor                 eax, ebx
            //   41880408             | rol                 edx, 7
            //   48ffc1               | rol                 eax, 0xc
            //   488d040a             | inc                 esp

        $sequence_11 = { c1e108 0bc8 0fb642fe c1e108 0bc8 41890c10 488d5204 }
            // n = 7, score = 200
            //   c1e108               | inc                 esp
            //   0bc8                 | add                 ebx, esi
            //   0fb642fe             | inc                 esp
            //   c1e108               | add                 ebp, eax
            //   0bc8                 | inc                 ecx
            //   41890c10             | xor                 ebx, ebx
            //   488d5204             | inc                 ecx

        $sequence_12 = { 488b05???????? 83780c00 7405 e8???????? 488b0d???????? }
            // n = 5, score = 200
            //   488b05????????       |                     
            //   83780c00             | cmp                 dword ptr [eax + 0xc], 0
            //   7405                 | je                  7
            //   e8????????           |                     
            //   488b0d????????       |                     

        $sequence_13 = { 89750b 4489750f 44897d03 448965ff }
            // n = 4, score = 200
            //   89750b               | inc                 esp
            //   4489750f             | add                 ebx, edi
            //   44897d03             | inc                 ecx
            //   448965ff             | rol                 esi, 0x10

    condition:
        7 of them and filesize < 237568
}