rule win_sierras_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sierras."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sierras"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 8dbc24fc000000 83c9ff 33c0 f2ae }
            // n = 5, score = 200
            //   e9????????           |                     
            //   8dbc24fc000000       | lea                 edi, [esp + 0xfc]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]

        $sequence_1 = { 83c408 8d94242c070000 52 ffd5 83f8ff 7516 8d84241c030000 }
            // n = 7, score = 200
            //   83c408               | add                 esp, 8
            //   8d94242c070000       | lea                 edx, [esp + 0x72c]
            //   52                   | push                edx
            //   ffd5                 | call                ebp
            //   83f8ff               | cmp                 eax, -1
            //   7516                 | jne                 0x18
            //   8d84241c030000       | lea                 eax, [esp + 0x31c]

        $sequence_2 = { 8974243c 741a 56 57 e8???????? 83c660 83c408 }
            // n = 7, score = 200
            //   8974243c             | mov                 dword ptr [esp + 0x3c], esi
            //   741a                 | je                  0x1c
            //   56                   | push                esi
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c660               | add                 esi, 0x60
            //   83c408               | add                 esp, 8

        $sequence_3 = { 817e601e010000 89465c 895df0 773e 837e641e 7738 }
            // n = 6, score = 200
            //   817e601e010000       | cmp                 dword ptr [esi + 0x60], 0x11e
            //   89465c               | mov                 dword ptr [esi + 0x5c], eax
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx
            //   773e                 | ja                  0x40
            //   837e641e             | cmp                 dword ptr [esi + 0x64], 0x1e
            //   7738                 | ja                  0x3a

        $sequence_4 = { 017514 03fb 3b7d10 72b0 8b5df0 834dfcff 8d4de0 }
            // n = 7, score = 200
            //   017514               | add                 dword ptr [ebp + 0x14], esi
            //   03fb                 | add                 edi, ebx
            //   3b7d10               | cmp                 edi, dword ptr [ebp + 0x10]
            //   72b0                 | jb                  0xffffffb2
            //   8b5df0               | mov                 ebx, dword ptr [ebp - 0x10]
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   8d4de0               | lea                 ecx, [ebp - 0x20]

        $sequence_5 = { f6461104 745f 83ff10 7321 837df800 0f84440d0000 8b45fc }
            // n = 7, score = 200
            //   f6461104             | test                byte ptr [esi + 0x11], 4
            //   745f                 | je                  0x61
            //   83ff10               | cmp                 edi, 0x10
            //   7321                 | jae                 0x23
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   0f84440d0000         | je                  0xd4a
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_6 = { ffd6 57 ffd6 8bc3 5b 5f 5e }
            // n = 7, score = 200
            //   ffd6                 | call                esi
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   8bc3                 | mov                 eax, ebx
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_7 = { ffd7 c745fcffffffff e8???????? 33c0 8b4df0 64890d00000000 }
            // n = 6, score = 200
            //   ffd7                 | call                edi
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx

        $sequence_8 = { 897dfc 0f8cc0000000 837d0801 7e58 }
            // n = 4, score = 200
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   0f8cc0000000         | jl                  0xc6
            //   837d0801             | cmp                 dword ptr [ebp + 8], 1
            //   7e58                 | jle                 0x5a

        $sequence_9 = { 33c0 f2ae f7d1 49 0f8452030000 8d8c24fc000000 }
            // n = 6, score = 200
            //   33c0                 | xor                 eax, eax
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   0f8452030000         | je                  0x358
            //   8d8c24fc000000       | lea                 ecx, [esp + 0xfc]

        $sequence_10 = { 56 8bf1 57 68???????? 8d8608020000 50 ff15???????? }
            // n = 7, score = 200
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi
            //   68????????           |                     
            //   8d8608020000         | lea                 eax, [esi + 0x208]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_11 = { 8bc3 837d0800 50 8b450c 7511 8b4dec }
            // n = 6, score = 200
            //   8bc3                 | mov                 eax, ebx
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   50                   | push                eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   7511                 | jne                 0x13
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]

        $sequence_12 = { 57 e8???????? 85c0 750d ff15???????? }
            // n = 5, score = 200
            //   57                   | push                edi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   750d                 | jne                 0xf
            //   ff15????????         |                     

        $sequence_13 = { c3 56 8bf1 e8???????? 8b8610010000 }
            // n = 5, score = 200
            //   c3                   | ret                 
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   e8????????           |                     
            //   8b8610010000         | mov                 eax, dword ptr [esi + 0x110]

        $sequence_14 = { 56 50 7507 e8???????? eb05 e8???????? 0175f0 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   50                   | push                eax
            //   7507                 | jne                 9
            //   e8????????           |                     
            //   eb05                 | jmp                 7
            //   e8????????           |                     
            //   0175f0               | add                 dword ptr [ebp - 0x10], esi

        $sequence_15 = { 837d0803 0f8fb0000000 397d10 897df0 0f86a4000000 8b7d14 8b450c }
            // n = 7, score = 200
            //   837d0803             | cmp                 dword ptr [ebp + 8], 3
            //   0f8fb0000000         | jg                  0xb6
            //   397d10               | cmp                 dword ptr [ebp + 0x10], edi
            //   897df0               | mov                 dword ptr [ebp - 0x10], edi
            //   0f86a4000000         | jbe                 0xaa
            //   8b7d14               | mov                 edi, dword ptr [ebp + 0x14]
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

    condition:
        7 of them and filesize < 131072
}