rule win_silon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.silon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.silon"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 8b956cfeffff 52 e8???????? 83c40c 837d8400 }
            // n = 6, score = 200
            //   51                   | push                ecx
            //   8b956cfeffff         | mov                 edx, dword ptr [ebp - 0x194]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   837d8400             | cmp                 dword ptr [ebp - 0x7c], 0

        $sequence_1 = { 898858080000 eb7c 8b55fc 8b8254080000 898514efffff }
            // n = 5, score = 200
            //   898858080000         | mov                 dword ptr [eax + 0x858], ecx
            //   eb7c                 | jmp                 0x7e
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b8254080000         | mov                 eax, dword ptr [edx + 0x854]
            //   898514efffff         | mov                 dword ptr [ebp - 0x10ec], eax

        $sequence_2 = { 83c404 8945a4 837da400 746e 8b55a8 }
            // n = 5, score = 200
            //   83c404               | add                 esp, 4
            //   8945a4               | mov                 dword ptr [ebp - 0x5c], eax
            //   837da400             | cmp                 dword ptr [ebp - 0x5c], 0
            //   746e                 | je                  0x70
            //   8b55a8               | mov                 edx, dword ptr [ebp - 0x58]

        $sequence_3 = { 0f868f000000 833d????????00 0f8482000000 c745e400000000 }
            // n = 4, score = 200
            //   0f868f000000         | jbe                 0x95
            //   833d????????00       |                     
            //   0f8482000000         | je                  0x88
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0

        $sequence_4 = { 50 6a00 e8???????? 83c410 89856cfeffff 83bd6cfeffff00 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   6a00                 | push                0
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   89856cfeffff         | mov                 dword ptr [ebp - 0x194], eax
            //   83bd6cfeffff00       | cmp                 dword ptr [ebp - 0x194], 0

        $sequence_5 = { 8d8de8f9ffff 51 68???????? 8d95e8fbffff }
            // n = 4, score = 200
            //   8d8de8f9ffff         | lea                 ecx, [ebp - 0x618]
            //   51                   | push                ecx
            //   68????????           |                     
            //   8d95e8fbffff         | lea                 edx, [ebp - 0x418]

        $sequence_6 = { 8b55fc 8b8254080000 8b4dfc 03815c080000 }
            // n = 4, score = 200
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b8254080000         | mov                 eax, dword ptr [edx + 0x854]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   03815c080000         | add                 eax, dword ptr [ecx + 0x85c]

        $sequence_7 = { 83c410 6a65 a1???????? 50 }
            // n = 4, score = 200
            //   83c410               | add                 esp, 0x10
            //   6a65                 | push                0x65
            //   a1????????           |                     
            //   50                   | push                eax

        $sequence_8 = { 8b85c4feffff 8945d4 0fb74dcd 85c9 7e34 0fb755cd }
            // n = 6, score = 200
            //   8b85c4feffff         | mov                 eax, dword ptr [ebp - 0x13c]
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   0fb74dcd             | movzx               ecx, word ptr [ebp - 0x33]
            //   85c9                 | test                ecx, ecx
            //   7e34                 | jle                 0x36
            //   0fb755cd             | movzx               edx, word ptr [ebp - 0x33]

        $sequence_9 = { 681d5b931f 6a05 e8???????? 8945fc 8b4510 50 }
            // n = 6, score = 200
            //   681d5b931f           | push                0x1f935b1d
            //   6a05                 | push                5
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 122880
}