rule win_sisfader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sisfader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sisfader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 85c0 b91d000000 0f44d9 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   b91d000000           | mov                 ecx, 0x1d
            //   0f44d9               | cmove               ebx, ecx

        $sequence_1 = { 741f 33c0 85c9 7419 }
            // n = 4, score = 300
            //   741f                 | je                  0x21
            //   33c0                 | xor                 eax, eax
            //   85c9                 | test                ecx, ecx
            //   7419                 | je                  0x1b

        $sequence_2 = { 8905???????? c705????????00000000 8b442440 8905???????? }
            // n = 4, score = 200
            //   8905????????         |                     
            //   c705????????00000000     |     
            //   8b442440             | mov                 eax, dword ptr [esp + 0x40]
            //   8905????????         |                     

        $sequence_3 = { ff15???????? 85c0 7e08 03d8 3bdf 7c98 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7e08                 | jle                 0xa
            //   03d8                 | add                 ebx, eax
            //   3bdf                 | cmp                 ebx, edi
            //   7c98                 | jl                  0xffffff9a

        $sequence_4 = { 33c0 83f801 7425 baffffffff }
            // n = 4, score = 200
            //   33c0                 | xor                 eax, eax
            //   83f801               | cmp                 eax, 1
            //   7425                 | je                  0x27
            //   baffffffff           | mov                 edx, 0xffffffff

        $sequence_5 = { 85c0 753e 8d47dc 8903 83f824 723b }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   753e                 | jne                 0x40
            //   8d47dc               | lea                 eax, [edi - 0x24]
            //   8903                 | mov                 dword ptr [ebx], eax
            //   83f824               | cmp                 eax, 0x24
            //   723b                 | jb                  0x3d

        $sequence_6 = { c705????????10000000 8b442430 8905???????? c705????????07000000 }
            // n = 4, score = 200
            //   c705????????10000000     |     
            //   8b442430             | mov                 eax, dword ptr [esp + 0x30]
            //   8905????????         |                     
            //   c705????????07000000     |     

        $sequence_7 = { eb5b 837d0800 751f 8b451c 50 8b4d18 }
            // n = 6, score = 200
            //   eb5b                 | jmp                 0x5d
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   751f                 | jne                 0x21
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]
            //   50                   | push                eax
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]

        $sequence_8 = { 8b4508 8b4808 51 ff15???????? 83c408 8945e0 }
            // n = 6, score = 200
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4808               | mov                 ecx, dword ptr [eax + 8]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   83c408               | add                 esp, 8
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax

        $sequence_9 = { 837c245000 7405 e9???????? 83bc248000000000 7539 }
            // n = 5, score = 200
            //   837c245000           | cmp                 dword ptr [esp + 0x50], 0
            //   7405                 | je                  7
            //   e9????????           |                     
            //   83bc248000000000     | cmp                 dword ptr [esp + 0x80], 0
            //   7539                 | jne                 0x3b

        $sequence_10 = { 837c245000 7402 eb12 c744245401000000 33c0 }
            // n = 5, score = 200
            //   837c245000           | cmp                 dword ptr [esp + 0x50], 0
            //   7402                 | je                  4
            //   eb12                 | jmp                 0x14
            //   c744245401000000     | mov                 dword ptr [esp + 0x54], 1
            //   33c0                 | xor                 eax, eax

        $sequence_11 = { 85c0 7502 eb71 8b45fc 8b08 }
            // n = 5, score = 200
            //   85c0                 | test                eax, eax
            //   7502                 | jne                 4
            //   eb71                 | jmp                 0x73
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_12 = { c7430438020000 66837c247c2e 751f 0fb744247e 6685c0 0f8496010000 6683f82e }
            // n = 7, score = 200
            //   c7430438020000       | mov                 dword ptr [ebx + 4], 0x238
            //   66837c247c2e         | cmp                 word ptr [esp + 0x7c], 0x2e
            //   751f                 | jne                 0x21
            //   0fb744247e           | movzx               eax, word ptr [esp + 0x7e]
            //   6685c0               | test                ax, ax
            //   0f8496010000         | je                  0x19c
            //   6683f82e             | cmp                 ax, 0x2e

        $sequence_13 = { ff15???????? 83c414 8945d8 837dd800 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   83c414               | add                 esp, 0x14
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   837dd800             | cmp                 dword ptr [ebp - 0x28], 0

        $sequence_14 = { 8b5118 52 8b45f4 8b4830 51 ff15???????? }
            // n = 6, score = 200
            //   8b5118               | mov                 edx, dword ptr [ecx + 0x18]
            //   52                   | push                edx
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b4830               | mov                 ecx, dword ptr [eax + 0x30]
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_15 = { ff15???????? 8945f8 837df800 7402 eb5b 837d0800 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7402                 | je                  4
            //   eb5b                 | jmp                 0x5d
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0

        $sequence_16 = { 83ec60 c745fc00000000 c745e000000000 6a40 8b450c 50 e8???????? }
            // n = 7, score = 200
            //   83ec60               | sub                 esp, 0x60
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   c745e000000000       | mov                 dword ptr [ebp - 0x20], 0
            //   6a40                 | push                0x40
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_17 = { e8???????? 85c0 7412 ba01000000 b910270000 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7412                 | je                  0x14
            //   ba01000000           | mov                 edx, 1
            //   b910270000           | mov                 ecx, 0x2710

        $sequence_18 = { 89442420 837c242001 7425 837c242002 }
            // n = 4, score = 200
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   837c242001           | cmp                 dword ptr [esp + 0x20], 1
            //   7425                 | je                  0x27
            //   837c242002           | cmp                 dword ptr [esp + 0x20], 2

        $sequence_19 = { 5e 5b 8be5 5d c3 3de3e00000 7511 }
            // n = 7, score = 200
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   3de3e00000           | cmp                 eax, 0xe0e3
            //   7511                 | jne                 0x13

        $sequence_20 = { 51 ff15???????? 85c0 0f85ba010000 8b55fc 837a0c00 0f84ad010000 }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f85ba010000         | jne                 0x1c0
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   837a0c00             | cmp                 dword ptr [edx + 0xc], 0
            //   0f84ad010000         | je                  0x1b3

        $sequence_21 = { 8a0410 30443924 41 3b4f04 72ee 8b4704 8bd7 }
            // n = 7, score = 200
            //   8a0410               | mov                 al, byte ptr [eax + edx]
            //   30443924             | xor                 byte ptr [ecx + edi + 0x24], al
            //   41                   | inc                 ecx
            //   3b4f04               | cmp                 ecx, dword ptr [edi + 4]
            //   72ee                 | jb                  0xfffffff0
            //   8b4704               | mov                 eax, dword ptr [edi + 4]
            //   8bd7                 | mov                 edx, edi

        $sequence_22 = { 7425 837c242002 7441 837c242003 }
            // n = 4, score = 200
            //   7425                 | je                  0x27
            //   837c242002           | cmp                 dword ptr [esp + 0x20], 2
            //   7441                 | je                  0x43
            //   837c242003           | cmp                 dword ptr [esp + 0x20], 3

        $sequence_23 = { 0f1086f0000000 c7400410000000 c7400c00000000 0f114014 }
            // n = 4, score = 200
            //   0f1086f0000000       | movups              xmm0, xmmword ptr [esi + 0xf0]
            //   c7400410000000       | mov                 dword ptr [eax + 4], 0x10
            //   c7400c00000000       | mov                 dword ptr [eax + 0xc], 0
            //   0f114014             | movups              xmmword ptr [eax + 0x14], xmm0

        $sequence_24 = { 8b442464 89442430 8b442468 89442434 }
            // n = 4, score = 200
            //   8b442464             | mov                 eax, dword ptr [esp + 0x64]
            //   89442430             | mov                 dword ptr [esp + 0x30], eax
            //   8b442468             | mov                 eax, dword ptr [esp + 0x68]
            //   89442434             | mov                 dword ptr [esp + 0x34], eax

        $sequence_25 = { a810 746a 8b570c 8d8c2460020000 6a00 e8???????? 83c404 }
            // n = 7, score = 200
            //   a810                 | test                al, 0x10
            //   746a                 | je                  0x6c
            //   8b570c               | mov                 edx, dword ptr [edi + 0xc]
            //   8d8c2460020000       | lea                 ecx, [esp + 0x260]
            //   6a00                 | push                0
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_26 = { 8bd0 83e20f 8a8c0a00010000 300c18 }
            // n = 4, score = 200
            //   8bd0                 | mov                 edx, eax
            //   83e20f               | and                 edx, 0xf
            //   8a8c0a00010000       | mov                 cl, byte ptr [edx + ecx + 0x100]
            //   300c18               | xor                 byte ptr [eax + ebx], cl

        $sequence_27 = { 685c020000 6a40 ffd6 0f1005???????? 8bf8 8b4508 0f114714 }
            // n = 7, score = 200
            //   685c020000           | push                0x25c
            //   6a40                 | push                0x40
            //   ffd6                 | call                esi
            //   0f1005????????       |                     
            //   8bf8                 | mov                 edi, eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0f114714             | movups              xmmword ptr [edi + 0x14], xmm0

        $sequence_28 = { 745d 837c242004 7479 837c242005 0f8480000000 e9???????? }
            // n = 6, score = 200
            //   745d                 | je                  0x5f
            //   837c242004           | cmp                 dword ptr [esp + 0x20], 4
            //   7479                 | je                  0x7b
            //   837c242005           | cmp                 dword ptr [esp + 0x20], 5
            //   0f8480000000         | je                  0x86
            //   e9????????           |                     

        $sequence_29 = { c700aaeeddff 33c0 894710 c7470430020000 8d4840 ff15???????? }
            // n = 6, score = 200
            //   c700aaeeddff         | mov                 dword ptr [eax], 0xffddeeaa
            //   33c0                 | xor                 eax, eax
            //   894710               | mov                 dword ptr [edi + 0x10], eax
            //   c7470430020000       | mov                 dword ptr [edi + 4], 0x230
            //   8d4840               | lea                 ecx, [eax + 0x40]
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 417792
}