rule win_skipper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.skipper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.skipper"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 6a00 6a03 68???????? 68???????? 6a50 }
            // n = 6, score = 600
            //   6a00                 | je                  0x13
            //   6a00                 | cmp                 dword ptr [edi], 0
            //   6a03                 | dec                 eax
            //   68????????           |                     
            //   68????????           |                     
            //   6a50                 | lea                 ecx, [0xa386]

        $sequence_1 = { e8???????? 6804010000 e8???????? 6804010000 8bf8 }
            // n = 5, score = 500
            //   e8????????           |                     
            //   6804010000           | add                 eax, eax
            //   e8????????           |                     
            //   6804010000           | mov                 dword ptr [ebp - 0x128], eax
            //   8bf8                 | push                0

        $sequence_2 = { ff15???????? 6a00 6a00 6a00 6a00 68???????? 68???????? }
            // n = 7, score = 500
            //   ff15????????         |                     
            //   6a00                 | push                0x104
            //   6a00                 | lea                 eax, [ebp - 0x110]
            //   6a00                 | push                eax
            //   6a00                 | mov                 ecx, dword ptr [ebp - 0x128]
            //   68????????           |                     
            //   68????????           |                     

        $sequence_3 = { b9???????? e8???????? 6a04 e8???????? 8bf8 57 }
            // n = 6, score = 400
            //   b9????????           |                     
            //   e8????????           |                     
            //   6a04                 | push                eax
            //   e8????????           |                     
            //   8bf8                 | mov                 dword ptr [ebp - 0x120], 0
            //   57                   | mov                 dword ptr [ebp - 0x124], ecx

        $sequence_4 = { 320439 47 8847ff 4e 0f8568ffffff 8b4dfc }
            // n = 6, score = 400
            //   320439               | lea                 edx, [ebp - 0x120]
            //   47                   | push                edx
            //   8847ff               | push                0
            //   4e                   | mov                 eax, dword ptr [ebp - 0x128]
            //   0f8568ffffff         | test                ebp, ebp
            //   8b4dfc               | jle                 0x96

        $sequence_5 = { 8d95fcfeffff 03d0 8b85f8feffff 8a1a 0fb6c0 8d8dfcfeffff }
            // n = 6, score = 400
            //   8d95fcfeffff         | dec                 ecx
            //   03d0                 | sub                 edi, ebx
            //   8b85f8feffff         | inc                 ecx
            //   8a1a                 | and                 ecx, 0x800000ff
            //   0fb6c0               | jge                 0x17
            //   8d8dfcfeffff         | jle                 0x94

        $sequence_6 = { 40 0fb60438 0fb6ca 03d8 03d9 81e3ff000080 7908 }
            // n = 7, score = 400
            //   40                   | dec                 ecx
            //   0fb60438             | sub                 edi, ebx
            //   0fb6ca               | inc                 ecx
            //   03d8                 | and                 ecx, 0x800000ff
            //   03d9                 | inc                 esp
            //   81e3ff000080         | add                 eax, eax
            //   7908                 | inc                 esp

        $sequence_7 = { 888405fcfeffff 40 3d00010000 7cf1 33db 33f6 }
            // n = 6, score = 400
            //   888405fcfeffff       | mov                 ecx, dword ptr [ebp - 0x12c]
            //   40                   | push                ecx
            //   3d00010000           | xor                 eax, ebp
            //   7cf1                 | mov                 dword ptr [ebp - 4], eax
            //   33db                 | push                edi
            //   33f6                 | lea                 eax, [ebp - 0x110]

        $sequence_8 = { e8???????? 83c404 6a00 6a64 52 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   83c404               | dec                 eax
            //   6a00                 | imul                edx, edx, 0x58
            //   6a64                 | dec                 eax
            //   52                   | mov                 eax, dword ptr [ecx + eax*8]

        $sequence_9 = { 0fb645f8 8a8c05f0feffff 888deffeffff 0fb655fc 0fb645f8 }
            // n = 5, score = 200
            //   0fb645f8             | jge                 0x16
            //   8a8c05f0feffff       | push                3
            //   888deffeffff         | push                0x50
            //   0fb655fc             | push                0
            //   0fb645f8             | push                3

        $sequence_10 = { 48897c2420 4156 4881ec10010000 488b05???????? }
            // n = 4, score = 200
            //   48897c2420           | movzx               edx, byte ptr [ebp - 4]
            //   4156                 | movzx               eax, byte ptr [ebp - 8]
            //   4881ec10010000       | mov                 cl, byte ptr [ebp + edx - 0x110]
            //   488b05????????       |                     

        $sequence_11 = { 83c101 898ddcfeffff 8b95dcfeffff 3b5514 0f8dcf000000 8b45f8 83c001 }
            // n = 7, score = 200
            //   83c101               | add                 esp, 4
            //   898ddcfeffff         | push                0
            //   8b95dcfeffff         | push                0x64
            //   3b5514               | push                edx
            //   0f8dcf000000         | push                eax
            //   8b45f8               | add                 esp, 4
            //   83c001               | push                0

        $sequence_12 = { 488b05???????? 4833c4 4889842400010000 4c8b9c2440010000 33c9 }
            // n = 5, score = 200
            //   488b05????????       |                     
            //   4833c4               | movzx               edx, byte ptr [ebp - 0x118]
            //   4889842400010000     | mov                 al, byte ptr [ebp - 0x111]
            //   4c8b9c2440010000     | mov                 byte ptr [ebp + edx - 0x110], al
            //   33c9                 | mov                 byte ptr [ebp + edx - 0x110], al

        $sequence_13 = { 0fb655fc 0fb645f8 8a8c15f0feffff 888c05f0feffff 0fb655fc 8a85effeffff 888415f0feffff }
            // n = 7, score = 200
            //   0fb655fc             | push                edx
            //   0fb645f8             | push                eax
            //   8a8c15f0feffff       | add                 esp, 4
            //   888c05f0feffff       | push                0
            //   0fb655fc             | push                0x64
            //   8a85effeffff         | push                edx
            //   888415f0feffff       | push                eax

        $sequence_14 = { 8885eefeffff 8b4d10 038ddcfeffff 0fbe11 }
            // n = 4, score = 200
            //   8885eefeffff         | push                0
            //   8b4d10               | push                0
            //   038ddcfeffff         | push                0x104
            //   0fbe11               | push                0x104

        $sequence_15 = { 7d0d 41ffca 4181ca00ffffff 41ffc2 0fb6c1 }
            // n = 5, score = 200
            //   7d0d                 | mov                 byte ptr [ebp + edx - 0x110], al
            //   41ffca               | add                 ecx, 1
            //   4181ca00ffffff       | mov                 dword ptr [ebp - 0x124], ecx
            //   41ffc2               | mov                 edx, dword ptr [ebp - 0x124]
            //   0fb6c1               | cmp                 edx, dword ptr [ebp + 0x14]

        $sequence_16 = { 888415f0feffff 0fb64df8 0fb6940df0feffff 0fb645fc 0fb68c05f0feffff 03d1 }
            // n = 6, score = 200
            //   888415f0feffff       | mov                 cl, byte ptr [ebp + edx - 0x110]
            //   0fb64df8             | mov                 byte ptr [ebp + eax - 0x110], cl
            //   0fb6940df0feffff     | movzx               edx, byte ptr [ebp - 0x118]
            //   0fb645fc             | dec                 eax
            //   0fb68c05f0feffff     | or                  eax, 0xffffff00
            //   03d1                 | inc                 eax

        $sequence_17 = { 48 0d00ffffff 40 8945f8 8b4df8 0fb6940df0feffff }
            // n = 6, score = 200
            //   48                   | push                0
            //   0d00ffffff           | push                0x64
            //   40                   | push                edx
            //   8945f8               | add                 esp, 4
            //   8b4df8               | push                0
            //   0fb6940df0feffff     | push                0x64

        $sequence_18 = { 41ffc8 4181c800ffffff 41ffc0 410fb6c0 }
            // n = 4, score = 200
            //   41ffc8               | movzx               edx, byte ptr [ebp - 0x118]
            //   4181c800ffffff       | mov                 al, byte ptr [ebp - 0x111]
            //   41ffc0               | mov                 byte ptr [ebp + edx - 0x110], al
            //   410fb6c0             | mov                 dword ptr [ebp - 0x124], 0

        $sequence_19 = { 450fb608 4803d0 0fb602 418800 44880a 410fb610 }
            // n = 6, score = 200
            //   450fb608             | movzx               ecx, byte ptr [ebp - 8]
            //   4803d0               | movzx               edx, byte ptr [ebp + ecx - 0x110]
            //   0fb602               | movzx               eax, byte ptr [ebp - 4]
            //   418800               | movzx               ecx, byte ptr [ebp + eax - 0x110]
            //   44880a               | add                 edx, ecx
            //   410fb610             | mov                 byte ptr [ebp - 0x111], cl

        $sequence_20 = { 8d1492 03d2 2bc2 4863d0 420fb60432 }
            // n = 5, score = 200
            //   8d1492               | jge                 0xe4
            //   03d2                 | mov                 eax, dword ptr [ebp - 8]
            //   2bc2                 | add                 eax, 1
            //   4863d0               | mov                 cl, byte ptr [ebp + edx - 0x110]
            //   420fb60432           | mov                 byte ptr [ebp + eax - 0x110], cl

        $sequence_21 = { 0fb695e8feffff 8a85effeffff 888415f0feffff e9???????? }
            // n = 4, score = 200
            //   0fb695e8feffff       | mov                 byte ptr [ebp - 0x111], cl
            //   8a85effeffff         | movzx               edx, byte ptr [ebp - 0x118]
            //   888415f0feffff       | mov                 eax, dword ptr [ebp - 0x120]
            //   e9????????           |                     

        $sequence_22 = { 488d1424 4c03c0 410fb6c2 450fb608 4803d0 0fb602 }
            // n = 6, score = 200
            //   488d1424             | mov                 byte ptr [ebp + eax - 0x110], cl
            //   4c03c0               | cmp                 dword ptr [ebp - 0x11c], 0x100
            //   410fb6c2             | jge                 0x17
            //   450fb608             | mov                 ecx, dword ptr [ebp - 0x11c]
            //   4803d0               | mov                 dl, byte ptr [ebp - 0x11c]
            //   0fb602               | jge                 0xf

        $sequence_23 = { 888deffeffff 0fb695e8feffff 8b85e0feffff 8a8c15f0feffff 888c05f0feffff 0fb695e8feffff }
            // n = 6, score = 200
            //   888deffeffff         | push                0x50
            //   0fb695e8feffff       | add                 esp, 4
            //   8b85e0feffff         | push                0
            //   8a8c15f0feffff       | push                0x64
            //   888c05f0feffff       | push                edx
            //   0fb695e8feffff       | add                 esp, 4

        $sequence_24 = { 492bfb ffc1 81e1ff000080 7d0a ffc9 }
            // n = 5, score = 200
            //   492bfb               | inc                 ecx
            //   ffc1                 | dec                 edx
            //   81e1ff000080         | inc                 ecx
            //   7d0a                 | or                  edx, 0xffffff00
            //   ffc9                 | inc                 ecx

        $sequence_25 = { 83e61f c1e606 03348520b72300 8b45e4 }
            // n = 4, score = 100
            //   83e61f               | inc                 ecx
            //   c1e606               | movzx               edx, byte ptr [eax]
            //   03348520b72300       | dec                 eax
            //   8b45e4               | mov                 dword ptr [esp + 0x20], edi

        $sequence_26 = { c78424a80000000f000000 c78424a400000000000000 c684249400000000 720f ffb424f4000000 e8???????? }
            // n = 6, score = 100
            //   c78424a80000000f000000     | push    0x104
            //   c78424a400000000000000     | mov    edi, eax
            //   c684249400000000     | push                0
            //   720f                 | push                edi
            //   ffb424f4000000       | push                0x104
            //   e8????????           |                     

        $sequence_27 = { 4883ec20 4863d9 488bf3 48c1fe05 4c8d3d32a50000 83e31f 486bdb58 }
            // n = 7, score = 100
            //   4883ec20             | dec                 eax
            //   4863d9               | lea                 eax, [0xaa43]
            //   488bf3               | jmp                 0xd
            //   48c1fe05             | dec                 eax
            //   4c8d3d32a50000       | add                 eax, 0x14
            //   83e31f               | mov                 dword ptr [eax], edi
            //   486bdb58             | je                  0x1c

        $sequence_28 = { 33c5 8945fc 57 8d85f0feffff 50 }
            // n = 5, score = 100
            //   33c5                 | movzx               eax, byte ptr [edx]
            //   8945fc               | dec                 ecx
            //   57                   | sub                 edi, ebx
            //   8d85f0feffff         | inc                 ecx
            //   50                   | and                 ecx, 0x800000ff

        $sequence_29 = { 488bcb 488bc3 488d15faa20000 48c1f805 }
            // n = 4, score = 100
            //   488bcb               | jae                 0x6d
            //   488bc3               | dec                 eax
            //   488d15faa20000       | mov                 ebx, edi
            //   48c1f805             | dec                 eax

        $sequence_30 = { 8985d8feffff 6a00 6804010000 8d85f0feffff 50 8b8dd8feffff 51 }
            // n = 7, score = 100
            //   8985d8feffff         | inc                 ecx
            //   6a00                 | movzx               eax, al
            //   6804010000           | dec                 eax
            //   8d85f0feffff         | xor                 eax, esp
            //   50                   | dec                 eax
            //   8b8dd8feffff         | mov                 dword ptr [esp + 0x100], eax
            //   51                   | dec                 esp

        $sequence_31 = { 7405 e8???????? 488b8ba0000000 488d05c3910000 483bc8 }
            // n = 5, score = 100
            //   7405                 | dec                 eax
            //   e8????????           |                     
            //   488b8ba0000000       | mov                 edi, ebx
            //   488d05c3910000       | and                 ebx, 0x1f
            //   483bc8               | je                  7

        $sequence_32 = { 4885c0 7509 488d0543aa0000 eb04 4883c014 8938 e8???????? }
            // n = 7, score = 100
            //   4885c0               | mov                 esi, edi
            //   7509                 | dec                 eax
            //   488d0543aa0000       | sar                 esi, 5
            //   eb04                 | dec                 esp
            //   4883c014             | lea                 esp, [0xae37]
            //   8938                 | and                 ebx, 0x1f
            //   e8????????           |                     

        $sequence_33 = { 50 6a00 8b8dd4feffff 51 ff15???????? }
            // n = 5, score = 100
            //   50                   | inc                 ebp
            //   6a00                 | movzx               ecx, byte ptr [eax]
            //   8b8dd4feffff         | dec                 eax
            //   51                   | add                 edx, eax
            //   ff15????????         |                     

        $sequence_34 = { 897e70 c686c800000043 c6864b01000043 c7466888a22300 }
            // n = 4, score = 100
            //   897e70               | mov                 ebx, dword ptr [esp + 0x140]
            //   c686c800000043       | xor                 ecx, ecx
            //   c6864b01000043       | inc                 ebp
            //   c7466888a22300       | movzx               ecx, byte ptr [eax]

        $sequence_35 = { eb0a c785d4feffffffff1f00 8b4508 50 6a00 }
            // n = 5, score = 100
            //   eb0a                 | inc                 ecx
            //   c785d4feffffffff1f00     | push    esi
            //   8b4508               | dec                 eax
            //   50                   | sub                 esp, 0x110
            //   6a00                 | dec                 eax

        $sequence_36 = { 85f6 7447 8802 8b048d606d4100 }
            // n = 4, score = 100
            //   85f6                 | push                0
            //   7447                 | push                0
            //   8802                 | push                edi
            //   8b048d606d4100       | push                0x1b

        $sequence_37 = { 741a 488d0579d80000 483bf8 740e 833f00 }
            // n = 5, score = 100
            //   741a                 | dec                 eax
            //   488d0579d80000       | mov                 ecx, ebx
            //   483bf8               | dec                 eax
            //   740e                 | mov                 eax, ebx
            //   833f00               | dec                 eax

        $sequence_38 = { 736b 488bdf 488bf7 48c1fe05 4c8d2537ae0000 83e31f }
            // n = 6, score = 100
            //   736b                 | dec                 eax
            //   488bdf               | mov                 ecx, dword ptr [ebx + 0xa0]
            //   488bf7               | dec                 eax
            //   48c1fe05             | lea                 eax, [0x91c3]
            //   4c8d2537ae0000       | dec                 eax
            //   83e31f               | cmp                 ecx, eax

        $sequence_39 = { 6a00 8b85d8feffff 50 8b8dd0feffff 51 6a00 6a00 }
            // n = 7, score = 100
            //   6a00                 | dec                 eax
            //   8b85d8feffff         | add                 edx, eax
            //   50                   | movzx               eax, byte ptr [edx]
            //   8b8dd0feffff         | inc                 ecx
            //   51                   | mov                 byte ptr [eax], al
            //   6a00                 | inc                 esp
            //   6a00                 | mov                 byte ptr [edx], cl

        $sequence_40 = { 8b45f4 46 83fa03 750e 8b0c85606d4100 }
            // n = 5, score = 100
            //   8b45f4               | push                0
            //   46                   | push                0
            //   83fa03               | push                eax
            //   750e                 | push                0
            //   8b0c85606d4100       | push                0

        $sequence_41 = { 7367 4863d9 4c8d359aa40000 488bfb 83e31f }
            // n = 5, score = 100
            //   7367                 | jae                 0x69
            //   4863d9               | dec                 eax
            //   4c8d359aa40000       | arpl                cx, bx
            //   488bfb               | dec                 esp
            //   83e31f               | lea                 esi, [0xa49a]

        $sequence_42 = { 488d0d86a30000 488bc2 83e21f 48c1f805 486bd258 488b04c1 }
            // n = 6, score = 100
            //   488d0d86a30000       | lea                 edx, [0xa2fa]
            //   488bc2               | dec                 eax
            //   83e21f               | sar                 eax, 5
            //   48c1f805             | dec                 eax
            //   486bd258             | test                eax, eax
            //   488b04c1             | jne                 0xe

        $sequence_43 = { 59 8945e4 8b7508 c7465cd8812300 33ff }
            // n = 5, score = 100
            //   59                   | lea                 edx, [esp]
            //   8945e4               | dec                 esp
            //   8b7508               | add                 eax, eax
            //   c7465cd8812300       | inc                 ecx
            //   33ff                 | movzx               eax, dl

        $sequence_44 = { 8bd8 85f6 7478 8b45fc }
            // n = 4, score = 100
            //   8bd8                 | push                0x104
            //   85f6                 | mov                 edi, eax
            //   7478                 | push                0
            //   8b45fc               | push                0x104

        $sequence_45 = { 83ef80 83c410 8975f0 897dec 3bf3 }
            // n = 5, score = 100
            //   83ef80               | push                0
            //   83c410               | push                3
            //   8975f0               | push                0x50
            //   897dec               | push                3
            //   3bf3                 | push                0x50

    condition:
        7 of them and filesize < 262144
}