rule win_skyplex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.skyplex."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.skyplex"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 0f84c8000000 68???????? 8d8538f7ffff 50 e8???????? 83c408 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f84c8000000         | je                  0xce
            //   68????????           |                     
            //   8d8538f7ffff         | lea                 eax, [ebp - 0x8c8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_1 = { c1f805 57 8d3c85c0af4100 8b07 83e61f c1e606 03c6 }
            // n = 7, score = 100
            //   c1f805               | sar                 eax, 5
            //   57                   | push                edi
            //   8d3c85c0af4100       | lea                 edi, [eax*4 + 0x41afc0]
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   03c6                 | add                 eax, esi

        $sequence_2 = { 6bc930 8975e0 8db1709c4100 8975e4 eb2a }
            // n = 5, score = 100
            //   6bc930               | imul                ecx, ecx, 0x30
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi
            //   8db1709c4100         | lea                 esi, [ecx + 0x419c70]
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi
            //   eb2a                 | jmp                 0x2c

        $sequence_3 = { f7bd1cf7ffff 8b849520f7ffff 50 8d8d40fbffff 51 ff15???????? }
            // n = 6, score = 100
            //   f7bd1cf7ffff         | idiv                dword ptr [ebp - 0x8e4]
            //   8b849520f7ffff       | mov                 eax, dword ptr [ebp + edx*4 - 0x8e0]
            //   50                   | push                eax
            //   8d8d40fbffff         | lea                 ecx, [ebp - 0x4c0]
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_4 = { 85c0 7430 68???????? 8d8d38f7ffff 51 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   7430                 | je                  0x32
            //   68????????           |                     
            //   8d8d38f7ffff         | lea                 ecx, [ebp - 0x8c8]
            //   51                   | push                ecx

        $sequence_5 = { 6a01 ff15???????? c78544f6ffff01000000 eb0f 8b8d44f6ffff }
            // n = 5, score = 100
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   c78544f6ffff01000000     | mov    dword ptr [ebp - 0x9bc], 1
            //   eb0f                 | jmp                 0x11
            //   8b8d44f6ffff         | mov                 ecx, dword ptr [ebp - 0x9bc]

        $sequence_6 = { e8???????? 83c404 99 f7bdc0f6ffff 8b9495c4f6ffff }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   99                   | cdq                 
            //   f7bdc0f6ffff         | idiv                dword ptr [ebp - 0x940]
            //   8b9495c4f6ffff       | mov                 edx, dword ptr [ebp + edx*4 - 0x93c]

        $sequence_7 = { 33f6 33c0 0fbe84c158564100 6a07 c1f804 }
            // n = 5, score = 100
            //   33f6                 | xor                 esi, esi
            //   33c0                 | xor                 eax, eax
            //   0fbe84c158564100     | movsx               eax, byte ptr [ecx + eax*8 + 0x415658]
            //   6a07                 | push                7
            //   c1f804               | sar                 eax, 4

        $sequence_8 = { 755b e8???????? 0fb6c8 85c9 }
            // n = 4, score = 100
            //   755b                 | jne                 0x5d
            //   e8????????           |                     
            //   0fb6c8               | movzx               ecx, al
            //   85c9                 | test                ecx, ecx

        $sequence_9 = { 8b02 8b4df0 51 8b502c ffd2 8945fc 837dfc00 }
            // n = 7, score = 100
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   51                   | push                ecx
            //   8b502c               | mov                 edx, dword ptr [eax + 0x2c]
            //   ffd2                 | call                edx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0

    condition:
        7 of them and filesize < 262144
}