rule win_slave_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.slave."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.slave"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 837df400 0f84f7250000 b80a000000 66894706 8a4704 24c3 }
            // n = 7, score = 300
            //   e9????????           |                     
            //   837df400             | cmp                 dword ptr [ebp - 0xc], 0
            //   0f84f7250000         | je                  0x25fd
            //   b80a000000           | mov                 eax, 0xa
            //   66894706             | mov                 word ptr [edi + 6], ax
            //   8a4704               | mov                 al, byte ptr [edi + 4]
            //   24c3                 | and                 al, 0xc3

        $sequence_1 = { 0c10 888694030000 eb8d 817b0800000040 0f85ea020000 8a9694030000 8a5c240e }
            // n = 7, score = 300
            //   0c10                 | or                  al, 0x10
            //   888694030000         | mov                 byte ptr [esi + 0x394], al
            //   eb8d                 | jmp                 0xffffff8f
            //   817b0800000040       | cmp                 dword ptr [ebx + 8], 0x40000000
            //   0f85ea020000         | jne                 0x2f0
            //   8a9694030000         | mov                 dl, byte ptr [esi + 0x394]
            //   8a5c240e             | mov                 bl, byte ptr [esp + 0xe]

        $sequence_2 = { 813e6f563412 7406 5e 33c0 5b 5d c3 }
            // n = 7, score = 300
            //   813e6f563412         | cmp                 dword ptr [esi], 0x1234566f
            //   7406                 | je                  8
            //   5e                   | pop                 esi
            //   33c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_3 = { 833d????????00 c705????????00000000 740a b9???????? e8???????? 833d????????00 c705????????00000000 }
            // n = 7, score = 300
            //   833d????????00       |                     
            //   c705????????00000000     |     
            //   740a                 | je                  0xc
            //   b9????????           |                     
            //   e8????????           |                     
            //   833d????????00       |                     
            //   c705????????00000000     |     

        $sequence_4 = { 3d00000001 0f8456030000 3d00000002 0f859a240000 }
            // n = 4, score = 300
            //   3d00000001           | cmp                 eax, 0x1000000
            //   0f8456030000         | je                  0x35c
            //   3d00000002           | cmp                 eax, 0x2000000
            //   0f859a240000         | jne                 0x24a0

        $sequence_5 = { 837f7401 894de8 7620 83bf8400000000 7417 8b8780000000 0345f4 }
            // n = 7, score = 300
            //   837f7401             | cmp                 dword ptr [edi + 0x74], 1
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx
            //   7620                 | jbe                 0x22
            //   83bf8400000000       | cmp                 dword ptr [edi + 0x84], 0
            //   7417                 | je                  0x19
            //   8b8780000000         | mov                 eax, dword ptr [edi + 0x80]
            //   0345f4               | add                 eax, dword ptr [ebp - 0xc]

        $sequence_6 = { 8bc8 83c408 3bd9 750b }
            // n = 4, score = 300
            //   8bc8                 | mov                 ecx, eax
            //   83c408               | add                 esp, 8
            //   3bd9                 | cmp                 ebx, ecx
            //   750b                 | jne                 0xd

        $sequence_7 = { 83c40c 028e08010000 888e08010000 80f9ff 730c 0fb6c1 }
            // n = 6, score = 300
            //   83c40c               | add                 esp, 0xc
            //   028e08010000         | add                 cl, byte ptr [esi + 0x108]
            //   888e08010000         | mov                 byte ptr [esi + 0x108], cl
            //   80f9ff               | cmp                 cl, 0xff
            //   730c                 | jae                 0xe
            //   0fb6c1               | movzx               eax, cl

        $sequence_8 = { 7307 0fb6c2 2bc8 eb02 33c9 0fb6c2 68???????? }
            // n = 7, score = 300
            //   7307                 | jae                 9
            //   0fb6c2               | movzx               eax, dl
            //   2bc8                 | sub                 ecx, eax
            //   eb02                 | jmp                 4
            //   33c9                 | xor                 ecx, ecx
            //   0fb6c2               | movzx               eax, dl
            //   68????????           |                     

        $sequence_9 = { ff15???????? 5f 5e c3 837e1800 7445 90 }
            // n = 7, score = 300
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   837e1800             | cmp                 dword ptr [esi + 0x18], 0
            //   7445                 | je                  0x47
            //   90                   | nop                 

    condition:
        7 of them and filesize < 532480
}