rule win_slothfulmedia_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.slothfulmedia."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.slothfulmedia"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8365f000 837d1400 53 56 57 0f86a0000000 8b5d10 }
            // n = 7, score = 200
            //   8365f000             | and                 dword ptr [ebp - 0x10], 0
            //   837d1400             | cmp                 dword ptr [ebp + 0x14], 0
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   0f86a0000000         | jbe                 0xa6
            //   8b5d10               | mov                 ebx, dword ptr [ebp + 0x10]

        $sequence_1 = { 68df3d7a6b 50 e8???????? 57 ff15???????? 57 }
            // n = 6, score = 200
            //   68df3d7a6b           | push                0x6b7a3ddf
            //   50                   | push                eax
            //   e8????????           |                     
            //   57                   | push                edi
            //   ff15????????         |                     
            //   57                   | push                edi

        $sequence_2 = { d1f8 8b45fc 7505 b8???????? 50 57 }
            // n = 6, score = 200
            //   d1f8                 | sar                 eax, 1
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   7505                 | jne                 7
            //   b8????????           |                     
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_3 = { 397df4 0f8640ffffff 8b4508 e8???????? cc 55 8bec }
            // n = 7, score = 200
            //   397df4               | cmp                 dword ptr [ebp - 0xc], edi
            //   0f8640ffffff         | jbe                 0xffffff46
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   e8????????           |                     
            //   cc                   | int3                
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_4 = { 33c0 eb17 57 ff750c }
            // n = 4, score = 200
            //   33c0                 | xor                 eax, eax
            //   eb17                 | jmp                 0x19
            //   57                   | push                edi
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_5 = { ff7320 6a00 6a00 ffb33c020000 ff15???????? 8945f8 }
            // n = 6, score = 200
            //   ff7320               | push                dword ptr [ebx + 0x20]
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ffb33c020000         | push                dword ptr [ebx + 0x23c]
            //   ff15????????         |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_6 = { ff7514 56 ff15???????? 56 ff15???????? 8b4508 eb02 }
            // n = 7, score = 200
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   eb02                 | jmp                 4

        $sequence_7 = { 1bd2 83daff 85d2 7422 83f805 761f }
            // n = 6, score = 200
            //   1bd2                 | sbb                 edx, edx
            //   83daff               | sbb                 edx, -1
            //   85d2                 | test                edx, edx
            //   7422                 | je                  0x24
            //   83f805               | cmp                 eax, 5
            //   761f                 | jbe                 0x21

        $sequence_8 = { ff15???????? 8b8c2410020000 5f 5e 33cc }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   8b8c2410020000       | mov                 ecx, dword ptr [esp + 0x210]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   33cc                 | xor                 ecx, esp

        $sequence_9 = { 6689442414 e8???????? 83c40c 6a00 ff15???????? 8b35???????? 8b3d???????? }
            // n = 7, score = 100
            //   6689442414           | mov                 word ptr [esp + 0x14], ax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   8b3d????????         |                     

        $sequence_10 = { 83c40c 6804010000 8d44240c 50 6a00 }
            // n = 5, score = 100
            //   83c40c               | add                 esp, 0xc
            //   6804010000           | push                0x104
            //   8d44240c             | lea                 eax, [esp + 0xc]
            //   50                   | push                eax
            //   6a00                 | push                0

        $sequence_11 = { 85c0 7507 ffd7 83f805 74ee 6804010000 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   ffd7                 | call                edi
            //   83f805               | cmp                 eax, 5
            //   74ee                 | je                  0xfffffff0
            //   6804010000           | push                0x104

        $sequence_12 = { 8b35???????? 8b3d???????? 90 68???????? ffd6 85c0 }
            // n = 6, score = 100
            //   8b35????????         |                     
            //   8b3d????????         |                     
            //   90                   | nop                 
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax

        $sequence_13 = { 8d4c2410 51 ff15???????? 8b8c2410020000 }
            // n = 4, score = 100
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8b8c2410020000       | mov                 ecx, dword ptr [esp + 0x210]

        $sequence_14 = { e8???????? 81c40c020000 c21000 3b0d???????? 7502 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   81c40c020000         | add                 esp, 0x20c
            //   c21000               | ret                 0x10
            //   3b0d????????         |                     
            //   7502                 | jne                 4

        $sequence_15 = { 6804010000 8d54240c 6a00 52 e8???????? 83c40c }
            // n = 6, score = 100
            //   6804010000           | push                0x104
            //   8d54240c             | lea                 edx, [esp + 0xc]
            //   6a00                 | push                0
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

    condition:
        7 of them and filesize < 122880
}