rule win_slowstepper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.slowstepper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.slowstepper"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a04 43 53 50 8945d4 8975e0 8975dc }
            // n = 7, score = 100
            //   6a04                 | push                4
            //   43                   | inc                 ebx
            //   53                   | push                ebx
            //   50                   | push                eax
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi
            //   8975dc               | mov                 dword ptr [ebp - 0x24], esi

        $sequence_1 = { e8???????? b001 e8???????? c3 68a4020000 b8???????? e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   b001                 | mov                 al, 1
            //   e8????????           |                     
            //   c3                   | ret                 
            //   68a4020000           | push                0x2a4
            //   b8????????           |                     
            //   e8????????           |                     

        $sequence_2 = { 83661000 83c414 8d45b8 c746140f000000 50 8bce c60600 }
            // n = 7, score = 100
            //   83661000             | and                 dword ptr [esi + 0x10], 0
            //   83c414               | add                 esp, 0x14
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   c746140f000000       | mov                 dword ptr [esi + 0x14], 0xf
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi
            //   c60600               | mov                 byte ptr [esi], 0

        $sequence_3 = { c645fc4c e8???????? 57 c645fc4b 56 8d8dcceeffff e8???????? }
            // n = 7, score = 100
            //   c645fc4c             | mov                 byte ptr [ebp - 4], 0x4c
            //   e8????????           |                     
            //   57                   | push                edi
            //   c645fc4b             | mov                 byte ptr [ebp - 4], 0x4b
            //   56                   | push                esi
            //   8d8dcceeffff         | lea                 ecx, [ebp - 0x1134]
            //   e8????????           |                     

        $sequence_4 = { 85c0 746b 395c241c 765e 53 ff742420 8d8c2474050000 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   746b                 | je                  0x6d
            //   395c241c             | cmp                 dword ptr [esp + 0x1c], ebx
            //   765e                 | jbe                 0x60
            //   53                   | push                ebx
            //   ff742420             | push                dword ptr [esp + 0x20]
            //   8d8c2474050000       | lea                 ecx, [esp + 0x574]

        $sequence_5 = { 59 85c0 7507 c605????????01 68???????? 8d9564ebffff 8bce }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   c605????????01       |                     
            //   68????????           |                     
            //   8d9564ebffff         | lea                 edx, [ebp - 0x149c]
            //   8bce                 | mov                 ecx, esi

        $sequence_6 = { 57 8d4db8 e9???????? 6a48 b8???????? e8???????? 8b4508 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   e9????????           |                     
            //   6a48                 | push                0x48
            //   b8????????           |                     
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_7 = { 8b8d70faffff 8d85ecfaffff 50 8d85ecfeffff 50 e8???????? 59 }
            // n = 7, score = 100
            //   8b8d70faffff         | mov                 ecx, dword ptr [ebp - 0x590]
            //   8d85ecfaffff         | lea                 eax, [ebp - 0x514]
            //   50                   | push                eax
            //   8d85ecfeffff         | lea                 eax, [ebp - 0x114]
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_8 = { ff6008 55 8bec 8b4904 8b01 5d ff600c }
            // n = 7, score = 100
            //   ff6008               | jmp                 dword ptr [eax + 8]
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4904               | mov                 ecx, dword ptr [ecx + 4]
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   5d                   | pop                 ebp
            //   ff600c               | jmp                 dword ptr [eax + 0xc]

        $sequence_9 = { 6bc00c 8d8405b8feffff 8d8da8feffff 3bc1 7422 8b08 8b95a8feffff }
            // n = 7, score = 100
            //   6bc00c               | imul                eax, eax, 0xc
            //   8d8405b8feffff       | lea                 eax, [ebp + eax - 0x148]
            //   8d8da8feffff         | lea                 ecx, [ebp - 0x158]
            //   3bc1                 | cmp                 eax, ecx
            //   7422                 | je                  0x24
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b95a8feffff         | mov                 edx, dword ptr [ebp - 0x158]

    condition:
        7 of them and filesize < 909312
}