rule win_snake_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.snake"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4c2408 8b54240c 85c9 7552 8400 8d480c 890c24 }
            // n = 7, score = 200
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   8b54240c             | mov                 edx, dword ptr [esp + 0xc]
            //   85c9                 | test                ecx, ecx
            //   7552                 | jne                 0x54
            //   8400                 | test                byte ptr [eax], al
            //   8d480c               | lea                 ecx, [eax + 0xc]
            //   890c24               | mov                 dword ptr [esp], ecx

        $sequence_1 = { 894c2404 c744240803000000 c744240c03000000 e8???????? 8b442418 8b4c241c 8b542410 }
            // n = 7, score = 200
            //   894c2404             | mov                 dword ptr [esp + 4], ecx
            //   c744240803000000     | mov                 dword ptr [esp + 8], 3
            //   c744240c03000000     | mov                 dword ptr [esp + 0xc], 3
            //   e8????????           |                     
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]

        $sequence_2 = { 8402 8401 8b4c2410 8b5c2414 8b6c240c 8b742434 eb10 }
            // n = 7, score = 200
            //   8402                 | test                byte ptr [edx], al
            //   8401                 | test                byte ptr [ecx], al
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   8b5c2414             | mov                 ebx, dword ptr [esp + 0x14]
            //   8b6c240c             | mov                 ebp, dword ptr [esp + 0xc]
            //   8b742434             | mov                 esi, dword ptr [esp + 0x34]
            //   eb10                 | jmp                 0x12

        $sequence_3 = { c7042401000000 c644240400 8b442420 89442408 e8???????? 8b44240c 8b4c2414 }
            // n = 7, score = 200
            //   c7042401000000       | mov                 dword ptr [esp], 1
            //   c644240400           | mov                 byte ptr [esp + 4], 0
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   e8????????           |                     
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]

        $sequence_4 = { 85c0 0f85c2070000 890d???????? e8???????? 8b05???????? 8b0c24 8b542404 }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   0f85c2070000         | jne                 0x7c8
            //   890d????????         |                     
            //   e8????????           |                     
            //   8b05????????         |                     
            //   8b0c24               | mov                 ecx, dword ptr [esp]
            //   8b542404             | mov                 edx, dword ptr [esp + 4]

        $sequence_5 = { 8b442418 8b4c2410 8b542414 8b5c241c 85c0 0f854f010000 8944243c }
            // n = 7, score = 200
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   8b5c241c             | mov                 ebx, dword ptr [esp + 0x1c]
            //   85c0                 | test                eax, eax
            //   0f854f010000         | jne                 0x155
            //   8944243c             | mov                 dword ptr [esp + 0x3c], eax

        $sequence_6 = { 89442434 890424 8b4c2430 894c2404 e8???????? 8b442434 ebce }
            // n = 7, score = 200
            //   89442434             | mov                 dword ptr [esp + 0x34], eax
            //   890424               | mov                 dword ptr [esp], eax
            //   8b4c2430             | mov                 ecx, dword ptr [esp + 0x30]
            //   894c2404             | mov                 dword ptr [esp + 4], ecx
            //   e8????????           |                     
            //   8b442434             | mov                 eax, dword ptr [esp + 0x34]
            //   ebce                 | jmp                 0xffffffd0

        $sequence_7 = { 894c2408 8954240c 89442410 e8???????? 8b4c2414 8b54241c 8b442424 }
            // n = 7, score = 200
            //   894c2408             | mov                 dword ptr [esp + 8], ecx
            //   8954240c             | mov                 dword ptr [esp + 0xc], edx
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   e8????????           |                     
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   8b54241c             | mov                 edx, dword ptr [esp + 0x1c]
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]

        $sequence_8 = { e8???????? 8b05???????? 8b4c2408 85c0 750d 890d???????? 81c408010000 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b05????????         |                     
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   85c0                 | test                eax, eax
            //   750d                 | jne                 0xf
            //   890d????????         |                     
            //   81c408010000         | add                 esp, 0x108

        $sequence_9 = { c744241400000000 8b842480000000 8b8c2484000000 8b542470 8b9c248c000000 31ed eb03 }
            // n = 7, score = 200
            //   c744241400000000     | mov                 dword ptr [esp + 0x14], 0
            //   8b842480000000       | mov                 eax, dword ptr [esp + 0x80]
            //   8b8c2484000000       | mov                 ecx, dword ptr [esp + 0x84]
            //   8b542470             | mov                 edx, dword ptr [esp + 0x70]
            //   8b9c248c000000       | mov                 ebx, dword ptr [esp + 0x8c]
            //   31ed                 | xor                 ebp, ebp
            //   eb03                 | jmp                 5

    condition:
        7 of them and filesize < 8134656
}