rule win_snake_disk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.snake_disk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.snake_disk"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 898558ffffff 85c0 0f84a30b0000 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   898558ffffff         | mov                 dword ptr [ebp - 0xa8], eax
            //   85c0                 | test                eax, eax
            //   0f84a30b0000         | je                  0xba9

        $sequence_1 = { e8???????? 898548ffffff 8b08 8b8184010000 8d4db4 898544ffffff 397dac }
            // n = 7, score = 100
            //   e8????????           |                     
            //   898548ffffff         | mov                 dword ptr [ebp - 0xb8], eax
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b8184010000         | mov                 eax, dword ptr [ecx + 0x184]
            //   8d4db4               | lea                 ecx, [ebp - 0x4c]
            //   898544ffffff         | mov                 dword ptr [ebp - 0xbc], eax
            //   397dac               | cmp                 dword ptr [ebp - 0x54], edi

        $sequence_2 = { e8???????? 898550ffffff 897dbc 3bf8 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   898550ffffff         | mov                 dword ptr [ebp - 0xb0], eax
            //   897dbc               | mov                 dword ptr [ebp - 0x44], edi
            //   3bf8                 | cmp                 edi, eax

        $sequence_3 = { e8???????? 89855cffffff ff7720 e8???????? }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89855cffffff         | mov                 dword ptr [ebp - 0xa4], eax
            //   ff7720               | push                dword ptr [edi + 0x20]
            //   e8????????           |                     

        $sequence_4 = { e8???????? 898560ffffff 85c0 0f8410070000 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   898560ffffff         | mov                 dword ptr [ebp - 0xa0], eax
            //   85c0                 | test                eax, eax
            //   0f8410070000         | je                  0x716

        $sequence_5 = { e8???????? 898550ffffff 59 59 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   898550ffffff         | mov                 dword ptr [ebp - 0xb0], eax
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx

        $sequence_6 = { e8???????? 89855cffffff 85c0 7874 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89855cffffff         | mov                 dword ptr [ebp - 0xa4], eax
            //   85c0                 | test                eax, eax
            //   7874                 | js                  0x76

        $sequence_7 = { e8???????? 898550ffffff 85c0 0f84a4000000 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   898550ffffff         | mov                 dword ptr [ebp - 0xb0], eax
            //   85c0                 | test                eax, eax
            //   0f84a4000000         | je                  0xaa

    condition:
        7 of them and filesize < 28734464
}