rule win_snatch_loader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.snatch_loader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.snatch_loader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 895dfc e8???????? 8bf0 85f6 744b 33c0 66894606 }
            // n = 7, score = 600
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   744b                 | je                  0x4d
            //   33c0                 | xor                 eax, eax
            //   66894606             | mov                 word ptr [esi + 6], ax

        $sequence_1 = { eb0e 8d4dfc 51 8d4df4 51 56 }
            // n = 6, score = 600
            //   eb0e                 | jmp                 0x10
            //   8d4dfc               | lea                 ecx, [ebp - 4]
            //   51                   | push                ecx
            //   8d4df4               | lea                 ecx, [ebp - 0xc]
            //   51                   | push                ecx
            //   56                   | push                esi

        $sequence_2 = { 7505 8b45fc eb0d 53 53 }
            // n = 5, score = 600
            //   7505                 | jne                 7
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   eb0d                 | jmp                 0xf
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_3 = { 57 8bfa 85c0 751d }
            // n = 4, score = 600
            //   57                   | push                edi
            //   8bfa                 | mov                 edi, edx
            //   85c0                 | test                eax, eax
            //   751d                 | jne                 0x1f

        $sequence_4 = { 8b7dfc eb04 ffd0 8bf8 a1???????? }
            // n = 5, score = 600
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]
            //   eb04                 | jmp                 6
            //   ffd0                 | call                eax
            //   8bf8                 | mov                 edi, eax
            //   a1????????           |                     

        $sequence_5 = { 8bc8 e8???????? a3???????? 85c0 7403 57 }
            // n = 6, score = 600
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   7403                 | je                  5
            //   57                   | push                edi

        $sequence_6 = { 8bf8 a1???????? 85c0 7522 6a02 59 }
            // n = 6, score = 600
            //   8bf8                 | mov                 edi, eax
            //   a1????????           |                     
            //   85c0                 | test                eax, eax
            //   7522                 | jne                 0x24
            //   6a02                 | push                2
            //   59                   | pop                 ecx

        $sequence_7 = { 32c3 43 8802 42 }
            // n = 4, score = 600
            //   32c3                 | xor                 al, bl
            //   43                   | inc                 ebx
            //   8802                 | mov                 byte ptr [edx], al
            //   42                   | inc                 edx

        $sequence_8 = { 76d8 33c0 48 5a 59 5f 5e }
            // n = 7, score = 500
            //   76d8                 | jbe                 0xffffffda
            //   33c0                 | xor                 eax, eax
            //   48                   | dec                 eax
            //   5a                   | pop                 edx
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_9 = { 59 5b 5a c9 c20c00 55 8bec }
            // n = 7, score = 500
            //   59                   | pop                 ecx
            //   5b                   | pop                 ebx
            //   5a                   | pop                 edx
            //   c9                   | leave               
            //   c20c00               | ret                 0xc
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_10 = { 8bec 83c4f8 53 56 57 51 52 }
            // n = 7, score = 500
            //   8bec                 | mov                 ebp, esp
            //   83c4f8               | add                 esp, -8
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_11 = { 0bc0 7454 394508 734f ff7510 }
            // n = 5, score = 500
            //   0bc0                 | or                  eax, eax
            //   7454                 | je                  0x56
            //   394508               | cmp                 dword ptr [ebp + 8], eax
            //   734f                 | jae                 0x51
            //   ff7510               | push                dword ptr [ebp + 0x10]

        $sequence_12 = { 33d2 33c9 8a0431 0ac0 741f }
            // n = 5, score = 500
            //   33d2                 | xor                 edx, edx
            //   33c9                 | xor                 ecx, ecx
            //   8a0431               | mov                 al, byte ptr [ecx + esi]
            //   0ac0                 | or                  al, al
            //   741f                 | je                  0x21

        $sequence_13 = { 3b45fc 773b 8b750c 8b7d10 037508 8bde }
            // n = 6, score = 500
            //   3b45fc               | cmp                 eax, dword ptr [ebp - 4]
            //   773b                 | ja                  0x3d
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   037508               | add                 esi, dword ptr [ebp + 8]
            //   8bde                 | mov                 ebx, esi

        $sequence_14 = { 741f 3a0439 7514 41 3b4df8 72ee 8bc2 }
            // n = 7, score = 500
            //   741f                 | je                  0x21
            //   3a0439               | cmp                 al, byte ptr [ecx + edi]
            //   7514                 | jne                 0x16
            //   41                   | inc                 ecx
            //   3b4df8               | cmp                 ecx, dword ptr [ebp - 8]
            //   72ee                 | jb                  0xfffffff0
            //   8bc2                 | mov                 eax, edx

        $sequence_15 = { 57 56 8b36 56 8b33 33c0 48 }
            // n = 7, score = 500
            //   57                   | push                edi
            //   56                   | push                esi
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   56                   | push                esi
            //   8b33                 | mov                 esi, dword ptr [ebx]
            //   33c0                 | xor                 eax, eax
            //   48                   | dec                 eax

    condition:
        7 of them and filesize < 262144
}