rule win_sobig_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sobig."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sobig"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c645fc01 e8???????? 56 8d4dc8 885dfc e8???????? 834dfcff }
            // n = 7, score = 100
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   e8????????           |                     
            //   56                   | push                esi
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]
            //   885dfc               | mov                 byte ptr [ebp - 4], bl
            //   e8????????           |                     
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff

        $sequence_1 = { 48 85c9 742e 53 40 57 }
            // n = 6, score = 100
            //   48                   | dec                 eax
            //   85c9                 | test                ecx, ecx
            //   742e                 | je                  0x30
            //   53                   | push                ebx
            //   40                   | inc                 eax
            //   57                   | push                edi

        $sequence_2 = { 50 e8???????? 83ec10 8d45b0 8bcc 8965c4 50 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83ec10               | sub                 esp, 0x10
            //   8d45b0               | lea                 eax, [ebp - 0x50]
            //   8bcc                 | mov                 ecx, esp
            //   8965c4               | mov                 dword ptr [ebp - 0x3c], esp
            //   50                   | push                eax

        $sequence_3 = { 034e18 83c418 c645fc03 51 }
            // n = 4, score = 100
            //   034e18               | add                 ecx, dword ptr [esi + 0x18]
            //   83c418               | add                 esp, 0x18
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   51                   | push                ecx

        $sequence_4 = { 7ced 85f6 7e15 8bce 8d75c0 8bc1 8bfb }
            // n = 7, score = 100
            //   7ced                 | jl                  0xffffffef
            //   85f6                 | test                esi, esi
            //   7e15                 | jle                 0x17
            //   8bce                 | mov                 ecx, esi
            //   8d75c0               | lea                 esi, [ebp - 0x40]
            //   8bc1                 | mov                 eax, ecx
            //   8bfb                 | mov                 edi, ebx

        $sequence_5 = { 8d4ddc e8???????? 85c0 0f84a0000000 68???????? 8d4ddc }
            // n = 6, score = 100
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f84a0000000         | je                  0xa6
            //   68????????           |                     
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]

        $sequence_6 = { 7505 b8???????? 50 8d8544fbffff 68???????? 50 ff15???????? }
            // n = 7, score = 100
            //   7505                 | jne                 7
            //   b8????????           |                     
            //   50                   | push                eax
            //   8d8544fbffff         | lea                 eax, [ebp - 0x4bc]
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_7 = { e8???????? e9???????? 6a10 8d45ac 6a00 50 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e9????????           |                     
            //   6a10                 | push                0x10
            //   8d45ac               | lea                 eax, [ebp - 0x54]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_8 = { 83c320 3b7e04 7cee 5b ff36 e8???????? 59 }
            // n = 7, score = 100
            //   83c320               | add                 ebx, 0x20
            //   3b7e04               | cmp                 edi, dword ptr [esi + 4]
            //   7cee                 | jl                  0xfffffff0
            //   5b                   | pop                 ebx
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_9 = { 3b7e08 7ce6 83c8ff 5f 5e 5b c20400 }
            // n = 7, score = 100
            //   3b7e08               | cmp                 edi, dword ptr [esi + 8]
            //   7ce6                 | jl                  0xffffffe8
            //   83c8ff               | or                  eax, 0xffffffff
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c20400               | ret                 4

    condition:
        7 of them and filesize < 262144
}