rule win_socelars_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.socelars."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.socelars"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b8b88000000 394830 7f1c 8b542430 8bcb 6a00 52 }
            // n = 7, score = 100
            //   8b8b88000000         | mov                 ecx, dword ptr [ebx + 0x88]
            //   394830               | cmp                 dword ptr [eax + 0x30], ecx
            //   7f1c                 | jg                  0x1e
            //   8b542430             | mov                 edx, dword ptr [esp + 0x30]
            //   8bcb                 | mov                 ecx, ebx
            //   6a00                 | push                0
            //   52                   | push                edx

        $sequence_1 = { 8b432c 035514 40 837d1800 89432c 8b4f04 894c2424 }
            // n = 7, score = 100
            //   8b432c               | mov                 eax, dword ptr [ebx + 0x2c]
            //   035514               | add                 edx, dword ptr [ebp + 0x14]
            //   40                   | inc                 eax
            //   837d1800             | cmp                 dword ptr [ebp + 0x18], 0
            //   89432c               | mov                 dword ptr [ebx + 0x2c], eax
            //   8b4f04               | mov                 ecx, dword ptr [edi + 4]
            //   894c2424             | mov                 dword ptr [esp + 0x24], ecx

        $sequence_2 = { e8???????? 83c40c 894590 8b4d90 51 8d4d98 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   894590               | mov                 dword ptr [ebp - 0x70], eax
            //   8b4d90               | mov                 ecx, dword ptr [ebp - 0x70]
            //   51                   | push                ecx
            //   8d4d98               | lea                 ecx, [ebp - 0x68]
            //   e8????????           |                     

        $sequence_3 = { 8b55b8 83c202 3b5524 7735 8b4520 0345b8 0fbe08 }
            // n = 7, score = 100
            //   8b55b8               | mov                 edx, dword ptr [ebp - 0x48]
            //   83c202               | add                 edx, 2
            //   3b5524               | cmp                 edx, dword ptr [ebp + 0x24]
            //   7735                 | ja                  0x37
            //   8b4520               | mov                 eax, dword ptr [ebp + 0x20]
            //   0345b8               | add                 eax, dword ptr [ebp - 0x48]
            //   0fbe08               | movsx               ecx, byte ptr [eax]

        $sequence_4 = { e8???????? c745fc00000000 8b5510 2b550c 8955d4 837dd400 766d }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   2b550c               | sub                 edx, dword ptr [ebp + 0xc]
            //   8955d4               | mov                 dword ptr [ebp - 0x2c], edx
            //   837dd400             | cmp                 dword ptr [ebp - 0x2c], 0
            //   766d                 | jbe                 0x6f

        $sequence_5 = { ff15???????? 83c404 8b4e68 85c9 7414 0fb7868c000000 3bf8 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   83c404               | add                 esp, 4
            //   8b4e68               | mov                 ecx, dword ptr [esi + 0x68]
            //   85c9                 | test                ecx, ecx
            //   7414                 | je                  0x16
            //   0fb7868c000000       | movzx               eax, word ptr [esi + 0x8c]
            //   3bf8                 | cmp                 edi, eax

        $sequence_6 = { ffd0 83c404 85c0 7417 b80a000000 5f 5e }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7417                 | je                  0x19
            //   b80a000000           | mov                 eax, 0xa
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_7 = { ff75f4 03c6 89461c ff712c 50 e8???????? 8b4dfc }
            // n = 7, score = 100
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   03c6                 | add                 eax, esi
            //   89461c               | mov                 dword ptr [esi + 0x1c], eax
            //   ff712c               | push                dword ptr [ecx + 0x2c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_8 = { e9???????? 83cbff 8b4db8 83790400 0f8579ffffff c745a000000000 c7410401000000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   83cbff               | or                  ebx, 0xffffffff
            //   8b4db8               | mov                 ecx, dword ptr [ebp - 0x48]
            //   83790400             | cmp                 dword ptr [ecx + 4], 0
            //   0f8579ffffff         | jne                 0xffffff7f
            //   c745a000000000       | mov                 dword ptr [ebp - 0x60], 0
            //   c7410401000000       | mov                 dword ptr [ecx + 4], 1

        $sequence_9 = { 8b7c2448 99 03f8 13ca 83c70a 897c2448 83d100 }
            // n = 7, score = 100
            //   8b7c2448             | mov                 edi, dword ptr [esp + 0x48]
            //   99                   | cdq                 
            //   03f8                 | add                 edi, eax
            //   13ca                 | adc                 ecx, edx
            //   83c70a               | add                 edi, 0xa
            //   897c2448             | mov                 dword ptr [esp + 0x48], edi
            //   83d100               | adc                 ecx, 0

    condition:
        7 of them and filesize < 2151424
}