rule win_sodamaster_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sodamaster."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sodamaster"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5d c3 8b04c5d4ca0010 5d c3 8bff 55 }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b04c5d4ca0010       | mov                 eax, dword ptr [eax*8 + 0x1000cad4]
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp

        $sequence_1 = { 83c002 6685c9 75f5 8b8d14fbffff 2bc2 }
            // n = 5, score = 100
            //   83c002               | add                 eax, 2
            //   6685c9               | test                cx, cx
            //   75f5                 | jne                 0xfffffff7
            //   8b8d14fbffff         | mov                 ecx, dword ptr [ebp - 0x4ec]
            //   2bc2                 | sub                 eax, edx

        $sequence_2 = { 8b748104 40 6a64 8945e8 ff15???????? 3bf3 }
            // n = 6, score = 100
            //   8b748104             | mov                 esi, dword ptr [ecx + eax*4 + 4]
            //   40                   | inc                 eax
            //   6a64                 | push                0x64
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   ff15????????         |                     
            //   3bf3                 | cmp                 esi, ebx

        $sequence_3 = { 8bc3 c1f805 8d3c85a0330110 8bf3 83e61f c1e606 }
            // n = 6, score = 100
            //   8bc3                 | mov                 eax, ebx
            //   c1f805               | sar                 eax, 5
            //   8d3c85a0330110       | lea                 edi, [eax*4 + 0x100133a0]
            //   8bf3                 | mov                 esi, ebx
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6

        $sequence_4 = { a3???????? a1???????? c705????????ee5c0010 8935???????? a3???????? }
            // n = 5, score = 100
            //   a3????????           |                     
            //   a1????????           |                     
            //   c705????????ee5c0010     |     
            //   8935????????         |                     
            //   a3????????           |                     

        $sequence_5 = { 2bc1 8d8df0efffff 51 8bc8 e8???????? 8b35???????? 83c404 }
            // n = 7, score = 100
            //   2bc1                 | sub                 eax, ecx
            //   8d8df0efffff         | lea                 ecx, [ebp - 0x1010]
            //   51                   | push                ecx
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   8b35????????         |                     
            //   83c404               | add                 esp, 4

        $sequence_6 = { 52 51 d1f8 50 8d9524ffffff }
            // n = 5, score = 100
            //   52                   | push                edx
            //   51                   | push                ecx
            //   d1f8                 | sar                 eax, 1
            //   50                   | push                eax
            //   8d9524ffffff         | lea                 edx, [ebp - 0xdc]

        $sequence_7 = { 85c0 743a 8b55ec 52 ff15???????? 8bf8 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   743a                 | je                  0x3c
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_8 = { 0f84d5000000 8b95e8efffff 53 8d85dcefffff 50 }
            // n = 5, score = 100
            //   0f84d5000000         | je                  0xdb
            //   8b95e8efffff         | mov                 edx, dword ptr [ebp - 0x1018]
            //   53                   | push                ebx
            //   8d85dcefffff         | lea                 eax, [ebp - 0x1024]
            //   50                   | push                eax

        $sequence_9 = { ff15???????? eb10 c745da64006c00 b96c000000 66894dde }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   eb10                 | jmp                 0x12
            //   c745da64006c00       | mov                 dword ptr [ebp - 0x26], 0x6c0064
            //   b96c000000           | mov                 ecx, 0x6c
            //   66894dde             | mov                 word ptr [ebp - 0x22], cx

    condition:
        7 of them and filesize < 134144
}