rule win_soraya_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.soraya."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.soraya"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 8d48bf 80f919 77f2 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   8d48bf               | lea                 ecx, [eax - 0x41]
            //   80f919               | cmp                 cl, 0x19
            //   77f2                 | ja                  0xfffffff4

        $sequence_1 = { 488d4dd0 488bd0 488bd8 ff15???????? 458bc7 33d2 }
            // n = 6, score = 100
            //   488d4dd0             | mov                 ecx, ebp
            //   488bd0               | dec                 ecx
            //   488bd8               | mov                 ecx, esi
            //   ff15????????         |                     
            //   458bc7               | jne                 0x13
            //   33d2                 | dec                 eax

        $sequence_2 = { 833800 7411 c1d30b 8b18 0fbdc1 8b45e4 }
            // n = 6, score = 100
            //   833800               | cmp                 dword ptr [eax], 0
            //   7411                 | je                  0x13
            //   c1d30b               | rcl                 ebx, 0xb
            //   8b18                 | mov                 ebx, dword ptr [eax]
            //   0fbdc1               | bsr                 eax, ecx
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]

        $sequence_3 = { 2bfa 037d0c 3bc7 72cd 8b4510 33c1 }
            // n = 6, score = 100
            //   2bfa                 | sub                 edi, edx
            //   037d0c               | add                 edi, dword ptr [ebp + 0xc]
            //   3bc7                 | cmp                 eax, edi
            //   72cd                 | jb                  0xffffffcf
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   33c1                 | xor                 eax, ecx

        $sequence_4 = { ba02c10d00 33c8 2bfa 2bca 0faff9 eb46 }
            // n = 6, score = 100
            //   ba02c10d00           | mov                 edx, 0xdc102
            //   33c8                 | xor                 ecx, eax
            //   2bfa                 | sub                 edi, edx
            //   2bca                 | sub                 ecx, edx
            //   0faff9               | imul                edi, ecx
            //   eb46                 | jmp                 0x48

        $sequence_5 = { ffd0 85c0 7536 8b75ec 83feff 742e }
            // n = 6, score = 100
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   7536                 | jne                 0x38
            //   8b75ec               | mov                 esi, dword ptr [ebp - 0x14]
            //   83feff               | cmp                 esi, -1
            //   742e                 | je                  0x30

        $sequence_6 = { 488bce ff15???????? 488bcd ff15???????? 498bce ff15???????? }
            // n = 6, score = 100
            //   488bce               | dec                 eax
            //   ff15????????         |                     
            //   488bcd               | lea                 ecx, [0xffffe01f]
            //   ff15????????         |                     
            //   498bce               | dec                 eax
            //   ff15????????         |                     

        $sequence_7 = { 488bcf ff15???????? 83f801 753b }
            // n = 4, score = 100
            //   488bcf               | add                 dword ptr [ecx + edx], eax
            //   ff15????????         |                     
            //   83f801               | mov                 ecx, dword ptr [edx + 4]
            //   753b                 | dec                 eax

        $sequence_8 = { 6a04 6800300000 6a0a 56 ff15???????? 8b3d???????? }
            // n = 6, score = 100
            //   6a04                 | push                4
            //   6800300000           | push                0x3000
            //   6a0a                 | push                0xa
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8b3d????????         |                     

        $sequence_9 = { 52 8d45d8 50 8b45f8 33c6 }
            // n = 5, score = 100
            //   52                   | push                edx
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   33c6                 | xor                 eax, esi

        $sequence_10 = { a1???????? 69c941370000 8bfa 33d2 f7f3 33d2 }
            // n = 6, score = 100
            //   a1????????           |                     
            //   69c941370000         | imul                ecx, ecx, 0x3741
            //   8bfa                 | mov                 edi, edx
            //   33d2                 | xor                 edx, edx
            //   f7f3                 | div                 ebx
            //   33d2                 | xor                 edx, edx

        $sequence_11 = { ffd7 68???????? 8d85f8fdffff 50 ffd6 e8???????? 50 }
            // n = 7, score = 100
            //   ffd7                 | call                edi
            //   68????????           |                     
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   e8????????           |                     
            //   50                   | push                eax

        $sequence_12 = { 4885c0 0f84b8000000 488364242000 4c8d442430 41b930000000 }
            // n = 5, score = 100
            //   4885c0               | mov                 eax, ebp
            //   0f84b8000000         | and                 ecx, 0xfff
            //   488364242000         | dec                 eax
            //   4c8d442430           | sub                 eax, dword ptr [esi + 0x30]
            //   41b930000000         | dec                 edx

        $sequence_13 = { 7511 488bc5 81e1ff0f0000 482b4630 4a010411 8b4a04 }
            // n = 6, score = 100
            //   7511                 | mov                 ecx, eax
            //   488bc5               | dec                 eax
            //   81e1ff0f0000         | lea                 ecx, [0xffffdffa]
            //   482b4630             | dec                 eax
            //   4a010411             | mov                 ecx, esi
            //   8b4a04               | dec                 eax

        $sequence_14 = { e8???????? 68???????? ff15???????? 8b3d???????? 8bd8 68???????? 53 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   68????????           |                     
            //   ff15????????         |                     
            //   8b3d????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   68????????           |                     
            //   53                   | push                ebx

        $sequence_15 = { 488d4550 4c8d442450 4183c9ff 33d2 33c9 }
            // n = 5, score = 100
            //   488d4550             | dec                 eax
            //   4c8d442450           | lea                 eax, [ebp + 0x50]
            //   4183c9ff             | dec                 esp
            //   33d2                 | lea                 eax, [esp + 0x50]
            //   33c9                 | inc                 ecx

        $sequence_16 = { 8d41f2 66898552ffffff 83c016 66898554ffffff }
            // n = 4, score = 100
            //   8d41f2               | lea                 eax, [ecx - 0xe]
            //   66898552ffffff       | mov                 word ptr [ebp - 0xae], ax
            //   83c016               | add                 eax, 0x16
            //   66898554ffffff       | mov                 word ptr [ebp - 0xac], ax

        $sequence_17 = { 72c8 4c891d???????? 488d0d1fe0ffff ff15???????? 488bc8 e8???????? 488d0dfadfffff }
            // n = 7, score = 100
            //   72c8                 | or                  ecx, 0xffffffff
            //   4c891d????????       |                     
            //   488d0d1fe0ffff       | xor                 edx, edx
            //   ff15????????         |                     
            //   488bc8               | xor                 ecx, ecx
            //   e8????????           |                     
            //   488d0dfadfffff       | jb                  0xffffffca

        $sequence_18 = { 8b45fc 8b7508 33c3 2bc7 }
            // n = 4, score = 100
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   33c3                 | xor                 eax, ebx
            //   2bc7                 | sub                 eax, edi

        $sequence_19 = { 3bf0 72e4 eb03 8b55fc }
            // n = 4, score = 100
            //   3bf0                 | cmp                 esi, eax
            //   72e4                 | jb                  0xffffffe6
            //   eb03                 | jmp                 5
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_20 = { 8b45ec 41 3bc8 72e8 8b7df4 8b45f0 }
            // n = 6, score = 100
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   41                   | inc                 ecx
            //   3bc8                 | cmp                 ecx, eax
            //   72e8                 | jb                  0xffffffea
            //   8b7df4               | mov                 edi, dword ptr [ebp - 0xc]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

        $sequence_21 = { 8b4dcc 8365f400 894dfc 0fb74b06 2bc7 49 }
            // n = 6, score = 100
            //   8b4dcc               | mov                 ecx, dword ptr [ebp - 0x34]
            //   8365f400             | and                 dword ptr [ebp - 0xc], 0
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   0fb74b06             | movzx               ecx, word ptr [ebx + 6]
            //   2bc7                 | sub                 eax, edi
            //   49                   | dec                 ecx

        $sequence_22 = { 6a0c 58 e8???????? 59 85c0 0f849e000000 2b75fc }
            // n = 7, score = 100
            //   6a0c                 | push                0xc
            //   58                   | pop                 eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   0f849e000000         | je                  0xa4
            //   2b75fc               | sub                 esi, dword ptr [ebp - 4]

    condition:
        7 of them and filesize < 188416
}