rule win_soundbill_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.soundbill."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.soundbill"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 55 56 4881ecb0030000 488b05???????? 4833c4 4889842470030000 488b8424f0030000 }
            // n = 7, score = 100
            //   55                   | dec                 ecx
            //   56                   | mov                 edi, eax
            //   4881ecb0030000       | dec                 eax
            //   488b05????????       |                     
            //   4833c4               | sub                 esp, 0xd0
            //   4889842470030000     | dec                 eax
            //   488b8424f0030000     | mov                 dword ptr [esp + 0x20], 0xfffffffe

        $sequence_1 = { 488b8da0000000 e8???????? 4883c420 5d c3 488d8a70000000 e9???????? }
            // n = 7, score = 100
            //   488b8da0000000       | xor                 ebx, ebx
            //   e8????????           |                     
            //   4883c420             | cmp                 byte ptr [ecx + 0x24], 0
            //   5d                   | je                  0x1c9
            //   c3                   | dec                 eax
            //   488d8a70000000       | cmp                 edi, dword ptr [eax + 0x18]
            //   e9????????           |                     

        $sequence_2 = { 750e 85c9 0f95c0 8806 83f901 760c eb03 }
            // n = 7, score = 100
            //   750e                 | mov                 eax, dword ptr [0x30]
            //   85c9                 | dec                 eax
            //   0f95c0               | mov                 ecx, dword ptr [ecx + 0x98]
            //   8806                 | dec                 eax
            //   83f901               | cmp                 ecx, dword ptr [eax + 0x10]
            //   760c                 | dec                 esp
            //   eb03                 | lea                 eax, [0x3a67d]

        $sequence_3 = { 48894a08 488d4808 e8???????? 488d0579b00200 488903 488bc3 4883c420 }
            // n = 7, score = 100
            //   48894a08             | mov                 dword ptr [ebx], 0
            //   488d4808             | mov                 byte ptr [ebx + 8], 1
            //   e8????????           |                     
            //   488d0579b00200       | cmp                 cl, byte ptr [ebp + 0xb]
            //   488903               | jne                 0x2144
            //   488bc3               | inc                 ecx
            //   4883c420             | mov                 byte ptr [ebp], 0x65

        $sequence_4 = { f20f5ce9 f2410f1004c1 488d15562b0100 f20f1014c2 }
            // n = 4, score = 100
            //   f20f5ce9             | jne                 0x110a
            //   f2410f1004c1         | dec                 esp
            //   488d15562b0100       | mov                 dword ptr [esi], esi
            //   f20f1014c2           | xor                 eax, eax

        $sequence_5 = { c644243001 44397c2440 7f10 ff442434 4885c9 7426 c644243c01 }
            // n = 7, score = 100
            //   c644243001           | lea                 ecx, [0xfffce7bd]
            //   44397c2440           | dec                 eax
            //   7f10                 | shl                 esi, 2
            //   ff442434             | movzx               eax, word ptr [ecx + edi*4 + 0x3d750]
            //   4885c9               | dec                 eax
            //   7426                 | lea                 edx, [ecx + 0x3ce40]
            //   c644243c01           | dec                 eax

        $sequence_6 = { 483305???????? 488d1516b70200 488bcb 488905???????? ff15???????? 483305???????? }
            // n = 6, score = 100
            //   483305????????       |                     
            //   488d1516b70200       | mov                 word ptr [esp + 0x48], 1
            //   488bcb               | mov                 byte ptr [ebp + 0x22], al
            //   488905????????       |                     
            //   ff15????????         |                     
            //   483305????????       |                     

        $sequence_7 = { ffd7 4c8bf0 4885c0 751e 498bcf ff15???????? 488bce }
            // n = 7, score = 100
            //   ffd7                 | mov                 eax, dword ptr [ebx + edx*8 + 0x50660]
            //   4c8bf0               | inc                 edx
            //   4885c0               | movzx               ecx, byte ptr [eax + edi*8 + 0x3e]
            //   751e                 | inc                 esi
            //   498bcf               | movsx               esp, byte ptr [ecx + ebx + 0x4e430]
            //   ff15????????         |                     
            //   488bce               | inc                 ecx

        $sequence_8 = { 418d542416 488d0d3f4b0100 e8???????? 488b0b 66443921 488bcb 744d }
            // n = 7, score = 100
            //   418d542416           | dec                 eax
            //   488d0d3f4b0100       | sar                 ecx, 6
            //   e8????????           |                     
            //   488b0b               | dec                 eax
            //   66443921             | lea                 edx, [edx + edx*8]
            //   488bcb               | dec                 ecx
            //   744d                 | mov                 ecx, dword ptr [eax + ecx*8]

        $sequence_9 = { 8b4018 25c0010000 83f840 0f84e7010000 }
            // n = 4, score = 100
            //   8b4018               | lea                 eax, [ebp - 0x51]
            //   25c0010000           | dec                 ecx
            //   83f840               | cmp                 edi, 0x10
            //   0f84e7010000         | dec                 ecx

    condition:
        7 of them and filesize < 973824
}