rule win_soundbite_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.soundbite."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.soundbite"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8dbd64fdffff 898590fdffff 889db7fdffff 899d64fdffff 899d68fdffff 899d6cfdffff }
            // n = 6, score = 100
            //   8dbd64fdffff         | lea                 edi, [ebp - 0x29c]
            //   898590fdffff         | mov                 dword ptr [ebp - 0x270], eax
            //   889db7fdffff         | mov                 byte ptr [ebp - 0x249], bl
            //   899d64fdffff         | mov                 dword ptr [ebp - 0x29c], ebx
            //   899d68fdffff         | mov                 dword ptr [ebp - 0x298], ebx
            //   899d6cfdffff         | mov                 dword ptr [ebp - 0x294], ebx

        $sequence_1 = { 51 8dbd64fdffff e8???????? c645fc02 8b13 8bb564fdffff 52 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8dbd64fdffff         | lea                 edi, [ebp - 0x29c]
            //   e8????????           |                     
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   8b13                 | mov                 edx, dword ptr [ebx]
            //   8bb564fdffff         | mov                 esi, dword ptr [ebp - 0x29c]
            //   52                   | push                edx

        $sequence_2 = { 8d7c5702 4b ebea 3bf8 0f83b2000000 0fb707 }
            // n = 6, score = 100
            //   8d7c5702             | lea                 edi, [edi + edx*2 + 2]
            //   4b                   | dec                 ebx
            //   ebea                 | jmp                 0xffffffec
            //   3bf8                 | cmp                 edi, eax
            //   0f83b2000000         | jae                 0xb8
            //   0fb707               | movzx               eax, word ptr [edi]

        $sequence_3 = { 0f849a010000 e8???????? 85c0 0f848d010000 8d85d8fcffff }
            // n = 5, score = 100
            //   0f849a010000         | je                  0x1a0
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f848d010000         | je                  0x193
            //   8d85d8fcffff         | lea                 eax, [ebp - 0x328]

        $sequence_4 = { c645fc04 8bbdf8fcffff 3bcb 0f83c9000000 8bd6 3bfa 0f87bf000000 }
            // n = 7, score = 100
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4
            //   8bbdf8fcffff         | mov                 edi, dword ptr [ebp - 0x308]
            //   3bcb                 | cmp                 ecx, ebx
            //   0f83c9000000         | jae                 0xcf
            //   8bd6                 | mov                 edx, esi
            //   3bfa                 | cmp                 edi, edx
            //   0f87bf000000         | ja                  0xc5

        $sequence_5 = { 898d54fdffff 898d58fdffff 8d8db7fdffff 40 51 8dbd50fdffff c685b7fdffff00 }
            // n = 7, score = 100
            //   898d54fdffff         | mov                 dword ptr [ebp - 0x2ac], ecx
            //   898d58fdffff         | mov                 dword ptr [ebp - 0x2a8], ecx
            //   8d8db7fdffff         | lea                 ecx, [ebp - 0x249]
            //   40                   | inc                 eax
            //   51                   | push                ecx
            //   8dbd50fdffff         | lea                 edi, [ebp - 0x2b0]
            //   c685b7fdffff00       | mov                 byte ptr [ebp - 0x249], 0

        $sequence_6 = { 395de4 741d 8bc7 c1f805 83e71f c1e706 8b048500cf4200 }
            // n = 7, score = 100
            //   395de4               | cmp                 dword ptr [ebp - 0x1c], ebx
            //   741d                 | je                  0x1f
            //   8bc7                 | mov                 eax, edi
            //   c1f805               | sar                 eax, 5
            //   83e71f               | and                 edi, 0x1f
            //   c1e706               | shl                 edi, 6
            //   8b048500cf4200       | mov                 eax, dword ptr [eax*4 + 0x42cf00]

        $sequence_7 = { ff15???????? 8bf0 8d85a0fdffff e8???????? e9???????? 8bb5a8fdffff 8d85a0fdffff }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   8d85a0fdffff         | lea                 eax, [ebp - 0x260]
            //   e8????????           |                     
            //   e9????????           |                     
            //   8bb5a8fdffff         | mov                 esi, dword ptr [ebp - 0x258]
            //   8d85a0fdffff         | lea                 eax, [ebp - 0x260]

        $sequence_8 = { 33049df02e4200 81e2ff000000 330495f03a4200 4f 0f85fcfdffff 83fe04 7250 }
            // n = 7, score = 100
            //   33049df02e4200       | xor                 eax, dword ptr [ebx*4 + 0x422ef0]
            //   81e2ff000000         | and                 edx, 0xff
            //   330495f03a4200       | xor                 eax, dword ptr [edx*4 + 0x423af0]
            //   4f                   | dec                 edi
            //   0f85fcfdffff         | jne                 0xfffffe02
            //   83fe04               | cmp                 esi, 4
            //   7250                 | jb                  0x52

        $sequence_9 = { 85f6 0f85b3020000 50 e8???????? 83c404 8db578fdffff e8???????? }
            // n = 7, score = 100
            //   85f6                 | test                esi, esi
            //   0f85b3020000         | jne                 0x2b9
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8db578fdffff         | lea                 esi, [ebp - 0x288]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 409600
}