rule win_spectre_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.spectre."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.spectre"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bce 50 ff750c ff7508 e8???????? 8d4de4 e8???????? }
            // n = 7, score = 100
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   e8????????           |                     

        $sequence_1 = { 6bc938 53 56 8b048538324700 8b7508 57 8bfe }
            // n = 7, score = 100
            //   6bc938               | imul                ecx, ecx, 0x38
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b048538324700       | mov                 eax, dword ptr [eax*4 + 0x473238]
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   57                   | push                edi
            //   8bfe                 | mov                 edi, esi

        $sequence_2 = { 8d4d20 e8???????? 8b4dfc 33cd 5e e8???????? c9 }
            // n = 7, score = 100
            //   8d4d20               | lea                 ecx, [ebp + 0x20]
            //   e8????????           |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   33cd                 | xor                 ecx, ebp
            //   5e                   | pop                 esi
            //   e8????????           |                     
            //   c9                   | leave               

        $sequence_3 = { 50 e8???????? 8b8424b4000000 83c434 8b4c247c 2bc1 83e830 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b8424b4000000       | mov                 eax, dword ptr [esp + 0xb4]
            //   83c434               | add                 esp, 0x34
            //   8b4c247c             | mov                 ecx, dword ptr [esp + 0x7c]
            //   2bc1                 | sub                 eax, ecx
            //   83e830               | sub                 eax, 0x30

        $sequence_4 = { c605????????01 e8???????? eb0c 881d???????? 881d???????? 8b442448 bb00100000 }
            // n = 7, score = 100
            //   c605????????01       |                     
            //   e8????????           |                     
            //   eb0c                 | jmp                 0xe
            //   881d????????         |                     
            //   881d????????         |                     
            //   8b442448             | mov                 eax, dword ptr [esp + 0x48]
            //   bb00100000           | mov                 ebx, 0x1000

        $sequence_5 = { 8bcf 89442420 e8???????? 89442410 8bc3 2b442414 6a18 }
            // n = 7, score = 100
            //   8bcf                 | mov                 ecx, edi
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   e8????????           |                     
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   8bc3                 | mov                 eax, ebx
            //   2b442414             | sub                 eax, dword ptr [esp + 0x14]
            //   6a18                 | push                0x18

        $sequence_6 = { 6a01 be???????? 8d8de4feffff 56 e8???????? 8d454c 50 }
            // n = 7, score = 100
            //   6a01                 | push                1
            //   be????????           |                     
            //   8d8de4feffff         | lea                 ecx, [ebp - 0x11c]
            //   56                   | push                esi
            //   e8????????           |                     
            //   8d454c               | lea                 eax, [ebp + 0x4c]
            //   50                   | push                eax

        $sequence_7 = { 8b4e0c b8ffffff7f 2bc1 3bc3 7279 83651000 8d4510 }
            // n = 7, score = 100
            //   8b4e0c               | mov                 ecx, dword ptr [esi + 0xc]
            //   b8ffffff7f           | mov                 eax, 0x7fffffff
            //   2bc1                 | sub                 eax, ecx
            //   3bc3                 | cmp                 eax, ebx
            //   7279                 | jb                  0x7b
            //   83651000             | and                 dword ptr [ebp + 0x10], 0
            //   8d4510               | lea                 eax, [ebp + 0x10]

        $sequence_8 = { 8d8c24fc010000 e8???????? 8d8424f8010000 50 8d842454010000 68???????? 50 }
            // n = 7, score = 100
            //   8d8c24fc010000       | lea                 ecx, [esp + 0x1fc]
            //   e8????????           |                     
            //   8d8424f8010000       | lea                 eax, [esp + 0x1f8]
            //   50                   | push                eax
            //   8d842454010000       | lea                 eax, [esp + 0x154]
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_9 = { e8???????? 8b44242c 83c40c 0430 89442420 8b44245c 8b542420 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b44242c             | mov                 eax, dword ptr [esp + 0x2c]
            //   83c40c               | add                 esp, 0xc
            //   0430                 | add                 al, 0x30
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   8b44245c             | mov                 eax, dword ptr [esp + 0x5c]
            //   8b542420             | mov                 edx, dword ptr [esp + 0x20]

    condition:
        7 of them and filesize < 990208
}