rule win_sphijacker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sphijacker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sphijacker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33db 488d154de60100 4533c0 488d0c9b 488d0cca baa00f0000 e8???????? }
            // n = 7, score = 100
            //   33db                 | dec                 esp
            //   488d154de60100       | lea                 eax, [ebp + 0x20]
            //   4533c0               | dec                 eax
            //   488d0c9b             | lea                 edx, [0x1e0fb]
            //   488d0cca             | dec                 eax
            //   baa00f0000           | lea                 edx, [0x1d22c]
            //   e8????????           |                     

        $sequence_1 = { 4885c9 741c 488d05208b0000 483bc8 7410 b801000000 f00fc1815c010000 }
            // n = 7, score = 100
            //   4885c9               | inc                 ecx
            //   741c                 | mov                 eax, 0x1ee
            //   488d05208b0000       | movaps              xmmword ptr [ebp + 0x1410], xmm0
            //   483bc8               | dec                 eax
            //   7410                 | lea                 ecx, [ebp + 0x334]
            //   b801000000           | mov                 dword ptr [ebp + 0x330], eax
            //   f00fc1815c010000     | dec                 eax

        $sequence_2 = { 488d159ee00100 ff15???????? 488b4d20 488d4510 c744242804000000 }
            // n = 5, score = 100
            //   488d159ee00100       | inc                 eax
            //   ff15????????         |                     
            //   488b4d20             | mov                 byte ptr [ebx + 0x24], ch
            //   488d4510             | je                  0x164
            //   c744242804000000     | lea                 eax, [ecx - 1]

        $sequence_3 = { 488d8d16120000 0f1005???????? 898510120000 33d2 0fb705???????? 41b8f2010000 }
            // n = 6, score = 100
            //   488d8d16120000       | test                eax, eax
            //   0f1005????????       |                     
            //   898510120000         | jne                 0x177d
            //   33d2                 | dec                 esp
            //   0fb705????????       |                     
            //   41b8f2010000         | lea                 eax, [0xcb8b]

        $sequence_4 = { 6666660f1f840000000000 803099 488d4004 4883e901 75f3 }
            // n = 5, score = 100
            //   6666660f1f840000000000     | lea    eax, [0x1bde4]
            //   803099               | dec                 eax
            //   488d4004             | arpl                word ptr [0xffffce24], cx
            //   4883e901             | dec                 eax
            //   75f3                 | lea                 edx, [0xffffcde1]

        $sequence_5 = { 488d4510 c744242804000000 488d158fdb0100 41b904000000 4889442420 }
            // n = 5, score = 100
            //   488d4510             | xor                 edx, edx
            //   c744242804000000     | inc                 ecx
            //   488d158fdb0100       | mov                 eax, 0x1ee
            //   41b904000000         | movaps              xmmword ptr [ebp + 0x1410], xmm0
            //   4889442420           | movsd               qword ptr [ebp + 0x1420], xmm1

        $sequence_6 = { 4533db 488d3d6b340000 4d85c9 488bc2 4c8be2 }
            // n = 5, score = 100
            //   4533db               | dec                 eax
            //   488d3d6b340000       | lea                 eax, [0x8ac0]
            //   4d85c9               | dec                 eax
            //   488bc2               | cmp                 ecx, eax
            //   4c8be2               | je                  0xcb4

        $sequence_7 = { 488b4d18 4c8d4520 488d158ee30100 ff15???????? 488b4d20 }
            // n = 5, score = 100
            //   488b4d18             | dec                 eax
            //   4c8d4520             | lea                 edx, [0xe931]
            //   488d158ee30100       | mov                 ecx, 0x9f20
            //   ff15????????         |                     
            //   488b4d20             | nop                 word ptr [eax + eax]

        $sequence_8 = { 8b442430 8bc8 cd29 488d0d765e0100 e8???????? 488b442428 }
            // n = 6, score = 100
            //   8b442430             | inc                 ecx
            //   8bc8                 | mov                 ecx, 0xf003f
            //   cd29                 | dec                 eax
            //   488d0d765e0100       | mov                 dword ptr [esp + 0x20], eax
            //   e8????????           |                     
            //   488b442428           | inc                 ebp

        $sequence_9 = { 57 4883ec20 418bf0 4c8d0d2b320100 8bda 4c8d051a320100 488bf9 }
            // n = 7, score = 100
            //   57                   | nop                 dword ptr [eax]
            //   4883ec20             | nop                 dword ptr [eax + eax]
            //   418bf0               | movzx               eax, word ptr [esp + ecx + 0x6c]
            //   4c8d0d2b320100       | cmp                 word ptr [ebp + ecx + 0x26a0], ax
            //   8bda                 | jne                 0x1be
            //   4c8d051a320100       | dec                 eax
            //   488bf9               | add                 ecx, 2

    condition:
        7 of them and filesize < 808960
}