rule win_splinter_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.splinter."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.splinter"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f048ff08 7510 488b4df0 4881c120020000 e8???????? 90 4883c420 }
            // n = 7, score = 100
            //   f048ff08             | dec                 eax
            //   7510                 | mov                 ecx, dword ptr [ebp - 8]
            //   488b4df0             |                     
            //   4881c120020000       |                     
            //   e8????????           |                     
            //   90                   | jne                 0x12
            //   4883c420             | dec                 eax

        $sequence_1 = { f048ff08 0f855dfeffff 4883c178 e8???????? e9???????? 488b8558010000 48894530 }
            // n = 7, score = 100
            //   f048ff08             | dec                 eax
            //   0f855dfeffff         | mov                 dword ptr [ebp + 0x90], 0
            //   4883c178             | nop                 dword ptr [eax]
            //   e8????????           |                     
            //   e9????????           |                     
            //   488b8558010000       | dec                 eax
            //   48894530             | mov                 ecx, dword ptr [ebp + 0x90]

        $sequence_2 = { 741b 4c39c0 0f847c000000 420fb61c02 80c3d0 49ffc0 80fb0a }
            // n = 7, score = 100
            //   741b                 | lea                 edx, [0x40fdd]
            //   4c39c0               | dec                 eax
            //   0f847c000000         | mov                 ecx, eax
            //   420fb61c02           | dec                 eax
            //   80c3d0               | mov                 ebx, eax
            //   49ffc0               | dec                 eax
            //   80fb0a               | mov                 eax, ebx

        $sequence_3 = { e9???????? 4c8d0547ba2d00 4889c2 e8???????? 4c8d0538ba2d00 4889c1 e8???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4c8d0547ba2d00       | mov                 dword ptr [esp + 0x90], eax
            //   4889c2               | dec                 eax
            //   e8????????           |                     
            //   4c8d0538ba2d00       | lea                 eax, [0x426c32]
            //   4889c1               | dec                 eax
            //   e8????????           |                     

        $sequence_4 = { e9???????? 8b05???????? 65488b0c2558000000 488b34c1 488d8e38020000 488d15c6f10000 e8???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b05????????         |                     
            //   65488b0c2558000000     | push    ebp
            //   488b34c1             | push                esi
            //   488d8e38020000       | dec                 eax
            //   488d15c6f10000       | sub                 esp, 0x38
            //   e8????????           |                     

        $sequence_5 = { f30f7f06 488b9de0030000 4885db 0f8411010000 488db550010000 488d95b0000000 41b898000000 }
            // n = 7, score = 100
            //   f30f7f06             | movdqu              xmmword ptr [ecx + 0x30], xmm3
            //   488b9de0030000       | movdqu              xmmword ptr [ecx + 0x20], xmm2
            //   4885db               | movdqu              xmmword ptr [ecx + 0x10], xmm1
            //   0f8411010000         | movdqu              xmmword ptr [ecx], xmm0
            //   488db550010000       | movdqu              xmm1, xmmword ptr [esi + 0x6c0]
            //   488d95b0000000       | movdqu              xmm2, xmmword ptr [esi + 0x6d0]
            //   41b898000000         | movdqu              xmm3, xmmword ptr [esi + 0x6e0]

        $sequence_6 = { e8???????? 84c0 488bbd08040000 743b 8b05???????? 65488b0c2558000000 488b04c1 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   84c0                 | movzx               ebx, byte ptr [esp + 0x25]
            //   488bbd08040000       | dec                 esp
            //   743b                 | mov                 ecx, dword ptr [esp + 0x28]
            //   8b05????????         |                     
            //   65488b0c2558000000     | je    0xfffffc56
            //   488b04c1             | jmp                 0x58

        $sequence_7 = { e8???????? eb17 4c8955e8 4c894df0 4c8d05cc034500 4889c1 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   eb17                 | dec                 eax
            //   4c8955e8             | mov                 ecx, ebx
            //   4c894df0             | dec                 eax
            //   4c8d05cc034500       | mov                 edx, edi
            //   4889c1               | ud2                 
            //   e8????????           |                     

        $sequence_8 = { f30f7f8910020000 488b4c2448 4c89ea e8???????? 4889f1 4821c1 f30f6f040f }
            // n = 7, score = 100
            //   f30f7f8910020000     | mov                 dword ptr [esi + 0x70], eax
            //   488b4c2448           | inc                 esp
            //   4c89ea               | mov                 byte ptr [esi + 0x78], ch
            //   e8????????           |                     
            //   4889f1               | dec                 eax
            //   4821c1               | mov                 eax, esi
            //   f30f6f040f           | dec                 eax

        $sequence_9 = { e8???????? eb2e c685c700000001 4c8d050b894c00 4c89f9 e8???????? eb16 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   eb2e                 | dec                 eax
            //   c685c700000001       | mov                 ecx, edx
            //   4c8d050b894c00       | jmp                 0x1f5
            //   4c89f9               | jmp                 0x207
            //   e8????????           |                     
            //   eb16                 | dec                 eax

    condition:
        7 of them and filesize < 20177920
}