rule win_spybot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.spybot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.spybot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8975f8 8975f0 68???????? ff750c ff7508 e8???????? 83c418 }
            // n = 7, score = 100
            //   8975f8               | mov                 dword ptr [ebp - 8], esi
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi
            //   68????????           |                     
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18

        $sequence_1 = { 6a03 8b5c2414 99 59 33ff f7f9 8bf2 }
            // n = 7, score = 100
            //   6a03                 | push                3
            //   8b5c2414             | mov                 ebx, dword ptr [esp + 0x14]
            //   99                   | cdq                 
            //   59                   | pop                 ecx
            //   33ff                 | xor                 edi, edi
            //   f7f9                 | idiv                ecx
            //   8bf2                 | mov                 esi, edx

        $sequence_2 = { 59 e9???????? 57 68???????? e8???????? 59 85c0 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   e9????????           |                     
            //   57                   | push                edi
            //   68????????           |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax

        $sequence_3 = { 33f6 ff7508 56 ff15???????? 85c0 7429 }
            // n = 6, score = 100
            //   33f6                 | xor                 esi, esi
            //   ff7508               | push                dword ptr [ebp + 8]
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7429                 | je                  0x2b

        $sequence_4 = { 33f6 ffb56cffffff 57 e8???????? 59 85c0 59 }
            // n = 7, score = 100
            //   33f6                 | xor                 esi, esi
            //   ffb56cffffff         | push                dword ptr [ebp - 0x94]
            //   57                   | push                edi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   59                   | pop                 ecx

        $sequence_5 = { 8945f0 8945f4 8945f8 8945fc a1???????? 85c0 7411 }
            // n = 7, score = 100
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   a1????????           |                     
            //   85c0                 | test                eax, eax
            //   7411                 | je                  0x13

        $sequence_6 = { 8bb43570ffffff 3bf3 897508 0f8469a4ffff 399d54ffffff 0f855da4ffff 68???????? }
            // n = 7, score = 100
            //   8bb43570ffffff       | mov                 esi, dword ptr [ebp + esi - 0x90]
            //   3bf3                 | cmp                 esi, ebx
            //   897508               | mov                 dword ptr [ebp + 8], esi
            //   0f8469a4ffff         | je                  0xffffa46f
            //   399d54ffffff         | cmp                 dword ptr [ebp - 0xac], ebx
            //   0f855da4ffff         | jne                 0xffffa463
            //   68????????           |                     

        $sequence_7 = { ff7020 8d85fcfdffff 68???????? 50 e8???????? 6a01 }
            // n = 6, score = 100
            //   ff7020               | push                dword ptr [eax + 0x20]
            //   8d85fcfdffff         | lea                 eax, [ebp - 0x204]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a01                 | push                1

        $sequence_8 = { ff7514 8975fc e8???????? 56 8945ec ff7510 897514 }
            // n = 7, score = 100
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   e8????????           |                     
            //   56                   | push                esi
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   897514               | mov                 dword ptr [ebp + 0x14], esi

        $sequence_9 = { e9???????? ffb570ffffff 68???????? e8???????? 59 85c0 59 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   ffb570ffffff         | push                dword ptr [ebp - 0x90]
            //   68????????           |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   59                   | pop                 ecx

    condition:
        7 of them and filesize < 2367488
}