rule win_spyder_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.spyder."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.spyder"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d057a150000 488905???????? 488d0590200000 488905???????? 488d0576150000 488905???????? }
            // n = 6, score = 500
            //   488d057a150000       | dec                 eax
            //   488905????????       |                     
            //   488d0590200000       | lea                 ecx, [ebx + 4]
            //   488905????????       |                     
            //   488d0576150000       | dec                 esp
            //   488905????????       |                     

        $sequence_1 = { 488bc8 ff15???????? 488d15385f0000 488bce 488905???????? ff15???????? }
            // n = 6, score = 500
            //   488bc8               | dec                 eax
            //   ff15????????         |                     
            //   488d15385f0000       | lea                 edx, [0x5e79]
            //   488bce               | dec                 eax
            //   488905????????       |                     
            //   ff15????????         |                     

        $sequence_2 = { 4181f9000000c0 7532 4585d2 756e 488d4b04 4c8d05563e0000 }
            // n = 6, score = 500
            //   4181f9000000c0       | mov                 ecx, esi
            //   7532                 | dec                 eax
            //   4585d2               | mov                 ecx, eax
            //   756e                 | dec                 eax
            //   488d4b04             | lea                 edx, [0x5f38]
            //   4c8d05563e0000       | dec                 eax

        $sequence_3 = { 4c8d05fc890000 498bd4 488bcd e8???????? 85c0 }
            // n = 5, score = 500
            //   4c8d05fc890000       | lea                 eax, [0x3e56]
            //   498bd4               | inc                 esp
            //   488bcd               | cmp                 ecx, esi
            //   e8????????           |                     
            //   85c0                 | jne                 0x41

        $sequence_4 = { 486bd258 488b04c1 488d4c1010 48ff25???????? 48895c2408 57 }
            // n = 6, score = 500
            //   486bd258             | inc                 ebp
            //   488b04c1             | test                edx, edx
            //   488d4c1010           | jne                 0x3c
            //   48ff25????????       |                     
            //   48895c2408           | dec                 eax
            //   57                   | lea                 ecx, [ebx + 4]

        $sequence_5 = { 4c8bd8 488905???????? 4885c0 7422 488d15795e0000 488bce ff15???????? }
            // n = 7, score = 500
            //   4c8bd8               | dec                 esp
            //   488905????????       |                     
            //   4885c0               | mov                 ebx, eax
            //   7422                 | dec                 eax
            //   488d15795e0000       | test                eax, eax
            //   488bce               | je                  0x27
            //   ff15????????         |                     

        $sequence_6 = { 488d0d68a10000 e8???????? 488d1584a10000 488d0d75a10000 e8???????? 90 }
            // n = 6, score = 500
            //   488d0d68a10000       | dec                 esp
            //   e8????????           |                     
            //   488d1584a10000       | lea                 eax, [0x3e17]
            //   488d0d75a10000       | inc                 ecx
            //   e8????????           |                     
            //   90                   | lea                 edx, [edx + 0x16]

        $sequence_7 = { 443bce 753c 4585d2 7537 488d4b04 4c8d05173e0000 418d5216 }
            // n = 7, score = 500
            //   443bce               | mov                 ecx, esi
            //   753c                 | inc                 ecx
            //   4585d2               | cmp                 ecx, 0xc0000000
            //   7537                 | jne                 0x3b
            //   488d4b04             | inc                 ebp
            //   4c8d05173e0000       | test                edx, edx
            //   418d5216             | jne                 0x73

        $sequence_8 = { 6803010000 f3ab 66ab aa 8d442414 50 }
            // n = 6, score = 100
            //   6803010000           | push                0x103
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   50                   | push                eax

        $sequence_9 = { 8b4c2414 81e2ffff0000 25ffff0000 52 8b542416 }
            // n = 5, score = 100
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   81e2ffff0000         | and                 edx, 0xffff
            //   25ffff0000           | and                 eax, 0xffff
            //   52                   | push                edx
            //   8b542416             | mov                 edx, dword ptr [esp + 0x16]

        $sequence_10 = { ff15???????? 5f 5e b801000000 5b 81c47c150000 c3 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   b801000000           | mov                 eax, 1
            //   5b                   | pop                 ebx
            //   81c47c150000         | add                 esp, 0x157c
            //   c3                   | ret                 

        $sequence_11 = { 8bec 8b4508 ff348570370910 ff15???????? 5d }
            // n = 5, score = 100
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   ff348570370910       | push                dword ptr [eax*4 + 0x10093770]
            //   ff15????????         |                     
            //   5d                   | pop                 ebp

        $sequence_12 = { c1f805 8d3c85204b0910 8bc3 83e01f }
            // n = 4, score = 100
            //   c1f805               | sar                 eax, 5
            //   8d3c85204b0910       | lea                 edi, [eax*4 + 0x10094b20]
            //   8bc3                 | mov                 eax, ebx
            //   83e01f               | and                 eax, 0x1f

        $sequence_13 = { 8944241a 66895c2410 668944241e ff15???????? 8b542418 8b442416 }
            // n = 6, score = 100
            //   8944241a             | mov                 dword ptr [esp + 0x1a], eax
            //   66895c2410           | mov                 word ptr [esp + 0x10], bx
            //   668944241e           | mov                 word ptr [esp + 0x1e], ax
            //   ff15????????         |                     
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   8b442416             | mov                 eax, dword ptr [esp + 0x16]

        $sequence_14 = { f3ab 8b8c248c150000 8d942488010000 66ab aa 8d842490150000 }
            // n = 6, score = 100
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8b8c248c150000       | mov                 ecx, dword ptr [esp + 0x158c]
            //   8d942488010000       | lea                 edx, [esp + 0x188]
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8d842490150000       | lea                 eax, [esp + 0x1590]

        $sequence_15 = { b918000000 33c0 8d7c2431 885c2430 }
            // n = 4, score = 100
            //   b918000000           | mov                 ecx, 0x18
            //   33c0                 | xor                 eax, eax
            //   8d7c2431             | lea                 edi, [esp + 0x31]
            //   885c2430             | mov                 byte ptr [esp + 0x30], bl

    condition:
        7 of them and filesize < 1458176
}