rule win_stabuniq_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.stabuniq."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stabuniq"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a05 8b55fc 52 8b4510 }
            // n = 4, score = 100
            //   6a05                 | push                5
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   52                   | push                edx
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_1 = { 8b913c020000 52 8b45ec 50 8b4df0 51 8b5508 }
            // n = 7, score = 100
            //   8b913c020000         | mov                 edx, dword ptr [ecx + 0x23c]
            //   52                   | push                edx
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   50                   | push                eax
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   51                   | push                ecx
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_2 = { 8b4508 50 8b4df8 ff91ec000000 8945fc 8b55f0 83ea04 }
            // n = 7, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   ff91ec000000         | call                dword ptr [ecx + 0xec]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   83ea04               | sub                 edx, 4

        $sequence_3 = { 8b55fc 52 8b4514 05ab0e0000 50 8b4d0c 51 }
            // n = 7, score = 100
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   52                   | push                edx
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   05ab0e0000           | add                 eax, 0xeab
            //   50                   | push                eax
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   51                   | push                ecx

        $sequence_4 = { 8b4d0c 8d9401b2170000 52 8d85f8fdffff 50 8b4d0c ff5130 }
            // n = 7, score = 100
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8d9401b2170000       | lea                 edx, [ecx + eax + 0x17b2]
            //   52                   | push                edx
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]
            //   50                   | push                eax
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   ff5130               | call                dword ptr [ecx + 0x30]

        $sequence_5 = { 50 8b8d24fdffff 51 8b5510 ff520c 6a40 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8b8d24fdffff         | mov                 ecx, dword ptr [ebp - 0x2dc]
            //   51                   | push                ecx
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   ff520c               | call                dword ptr [edx + 0xc]
            //   6a40                 | push                0x40

        $sequence_6 = { 85c0 7535 8b8decfbffff 6bc928 8b5510 8d840ab2170000 50 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7535                 | jne                 0x37
            //   8b8decfbffff         | mov                 ecx, dword ptr [ebp - 0x414]
            //   6bc928               | imul                ecx, ecx, 0x28
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   8d840ab2170000       | lea                 eax, [edx + ecx + 0x17b2]
            //   50                   | push                eax

        $sequence_7 = { c745f800000000 837dfc00 7e32 8b55f8 83c201 8955f8 8b45fc }
            // n = 7, score = 100
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   7e32                 | jle                 0x34
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   83c201               | add                 edx, 1
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_8 = { 83ba8000000000 750a b801000000 e9???????? 8b45f0 8b8880000000 034d08 }
            // n = 7, score = 100
            //   83ba8000000000       | cmp                 dword ptr [edx + 0x80], 0
            //   750a                 | jne                 0xc
            //   b801000000           | mov                 eax, 1
            //   e9????????           |                     
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b8880000000         | mov                 ecx, dword ptr [eax + 0x80]
            //   034d08               | add                 ecx, dword ptr [ebp + 8]

        $sequence_9 = { 8b4510 8b4d18 8a9411dc0e0000 8810 8b4510 83c001 }
            // n = 6, score = 100
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   8a9411dc0e0000       | mov                 dl, byte ptr [ecx + edx + 0xedc]
            //   8810                 | mov                 byte ptr [eax], dl
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   83c001               | add                 eax, 1

    condition:
        7 of them and filesize < 57344
}