rule win_stealbit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.stealbit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stealbit"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 66899528feffff 6689bd30feffff 66899d38feffff 6689bd3efeffff 6689bd42feffff 66894dbc 66895dc0 }
            // n = 7, score = 300
            //   66899528feffff       | mov                 word ptr [ebp - 0x1d8], dx
            //   6689bd30feffff       | mov                 word ptr [ebp - 0x1d0], di
            //   66899d38feffff       | mov                 word ptr [ebp - 0x1c8], bx
            //   6689bd3efeffff       | mov                 word ptr [ebp - 0x1c2], di
            //   6689bd42feffff       | mov                 word ptr [ebp - 0x1be], di
            //   66894dbc             | mov                 word ptr [ebp - 0x44], cx
            //   66895dc0             | mov                 word ptr [ebp - 0x40], bx

        $sequence_1 = { 0f8544010000 6a07 5b 53 8d45bc 8bd6 }
            // n = 6, score = 300
            //   0f8544010000         | jne                 0x14a
            //   6a07                 | push                7
            //   5b                   | pop                 ebx
            //   53                   | push                ebx
            //   8d45bc               | lea                 eax, [ebp - 0x44]
            //   8bd6                 | mov                 edx, esi

        $sequence_2 = { 8bc2 5d c20400 8bd1 8b0a e8???????? 8bc8 }
            // n = 7, score = 300
            //   8bc2                 | mov                 eax, edx
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   8bd1                 | mov                 edx, ecx
            //   8b0a                 | mov                 ecx, dword ptr [edx]
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax

        $sequence_3 = { 8d47f1 c745f877caeb85 03c3 bf28442324 8365fc00 be4f86c861 }
            // n = 6, score = 300
            //   8d47f1               | lea                 eax, [edi - 0xf]
            //   c745f877caeb85       | mov                 dword ptr [ebp - 8], 0x85ebca77
            //   03c3                 | add                 eax, ebx
            //   bf28442324           | mov                 edi, 0x24234428
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   be4f86c861           | mov                 esi, 0x61c8864f

        $sequence_4 = { 2ac8 8ac1 5d c20400 55 8bec }
            // n = 6, score = 300
            //   2ac8                 | sub                 cl, al
            //   8ac1                 | mov                 al, cl
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_5 = { 88460d 57 886e0e 884e0f 6a25 885610 e8???????? }
            // n = 7, score = 300
            //   88460d               | mov                 byte ptr [esi + 0xd], al
            //   57                   | push                edi
            //   886e0e               | mov                 byte ptr [esi + 0xe], ch
            //   884e0f               | mov                 byte ptr [esi + 0xf], cl
            //   6a25                 | push                0x25
            //   885610               | mov                 byte ptr [esi + 0x10], dl
            //   e8????????           |                     

        $sequence_6 = { 8b450c 48 83e801 740e 83e801 750f 8b4508 }
            // n = 7, score = 300
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   48                   | dec                 eax
            //   83e801               | sub                 eax, 1
            //   740e                 | je                  0x10
            //   83e801               | sub                 eax, 1
            //   750f                 | jne                 0x11
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_7 = { 33c0 66898518ffffff 58 6a74 66898506ffffff 6689b540ffffff }
            // n = 6, score = 300
            //   33c0                 | xor                 eax, eax
            //   66898518ffffff       | mov                 word ptr [ebp - 0xe8], ax
            //   58                   | pop                 eax
            //   6a74                 | push                0x74
            //   66898506ffffff       | mov                 word ptr [ebp - 0xfa], ax
            //   6689b540ffffff       | mov                 word ptr [ebp - 0xc0], si

        $sequence_8 = { 8945f8 e8???????? 03c0 8bce 8bd0 e8???????? 6a0c }
            // n = 7, score = 300
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   e8????????           |                     
            //   03c0                 | add                 eax, eax
            //   8bce                 | mov                 ecx, esi
            //   8bd0                 | mov                 edx, eax
            //   e8????????           |                     
            //   6a0c                 | push                0xc

        $sequence_9 = { 6a20 66899524ffffff 6689952effffff 5a 6a6e 58 6a6d }
            // n = 7, score = 300
            //   6a20                 | push                0x20
            //   66899524ffffff       | mov                 word ptr [ebp - 0xdc], dx
            //   6689952effffff       | mov                 word ptr [ebp - 0xd2], dx
            //   5a                   | pop                 edx
            //   6a6e                 | push                0x6e
            //   58                   | pop                 eax
            //   6a6d                 | push                0x6d

    condition:
        7 of them and filesize < 131072
}