rule win_stealc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.stealc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stealc"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? e8???????? 81c480000000 e9???????? }
            // n = 4, score = 600
            //   e8????????           |                     
            //   e8????????           |                     
            //   81c480000000         | add                 esp, 0x80
            //   e9????????           |                     

        $sequence_1 = { e8???????? e8???????? 83c418 6a3c }
            // n = 4, score = 600
            //   e8????????           |                     
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   6a3c                 | push                0x3c

        $sequence_2 = { e8???????? 83c460 e8???????? 83c40c }
            // n = 4, score = 600
            //   e8????????           |                     
            //   83c460               | add                 esp, 0x60
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_3 = { ff15???????? 85c0 7507 c685e0feffff43 }
            // n = 4, score = 600
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   c685e0feffff43       | mov                 byte ptr [ebp - 0x120], 0x43

        $sequence_4 = { 68???????? e8???????? e8???????? 83c474 }
            // n = 4, score = 600
            //   68????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   83c474               | add                 esp, 0x74

        $sequence_5 = { 50 e8???????? e8???????? 81c484000000 }
            // n = 4, score = 600
            //   50                   | push                eax
            //   e8????????           |                     
            //   e8????????           |                     
            //   81c484000000         | add                 esp, 0x84

        $sequence_6 = { 8d85dcf7ffff 50 8b450c 53 ff30 895df0 }
            // n = 6, score = 400
            //   8d85dcf7ffff         | lea                 eax, [ebp - 0x824]
            //   50                   | push                eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   53                   | push                ebx
            //   ff30                 | push                dword ptr [eax]
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx

        $sequence_7 = { 8d85dcf7ffff 50 ff15???????? 85c0 0f84a1000000 }
            // n = 5, score = 400
            //   8d85dcf7ffff         | lea                 eax, [ebp - 0x824]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f84a1000000         | je                  0xa7

        $sequence_8 = { e8???????? e8???????? 83c47c e9???????? }
            // n = 4, score = 300
            //   e8????????           |                     
            //   e8????????           |                     
            //   83c47c               | sub                 ecx, edx
            //   e9????????           |                     

        $sequence_9 = { 69c10ba31400 894d80 2bc2 66894584 }
            // n = 4, score = 200
            //   69c10ba31400         | mov                 dword ptr [ebp - 0x80], ecx
            //   894d80               | sub                 eax, edx
            //   2bc2                 | mov                 word ptr [ebp - 0x7c], ax
            //   66894584             | imul                eax, ecx, 0x1e70fd87

        $sequence_10 = { e9???????? 694d940ba31400 ba51754269 2bca }
            // n = 4, score = 200
            //   e9????????           |                     
            //   694d940ba31400       | imul                ecx, dword ptr [ebp - 0x6c], 0x14a30b
            //   ba51754269           | mov                 edx, 0x69427551
            //   2bca                 | sub                 ecx, edx

        $sequence_11 = { 2bca 884c0588 48ffc0 4883f808 }
            // n = 4, score = 200
            //   2bca                 | sub                 ecx, edx
            //   884c0588             | mov                 byte ptr [ebp + eax - 0x78], cl
            //   48ffc0               | dec                 eax
            //   4883f808             | inc                 eax

        $sequence_12 = { 2bc2 66894584 69c187fd701e b934eddb95 }
            // n = 4, score = 200
            //   2bc2                 | sub                 eax, edx
            //   66894584             | mov                 word ptr [ebp - 0x7c], ax
            //   69c187fd701e         | imul                eax, ecx, 0x1e70fd87
            //   b934eddb95           | mov                 ecx, 0x95dbed34

        $sequence_13 = { 85c0 750a b043 66c745a04300 eb03 8a45a0 }
            // n = 6, score = 200
            //   85c0                 | mov                 dword ptr [ebp - 0x6c], ecx
            //   750a                 | mov                 ecx, 0x25
            //   b043                 | imul                eax, ecx, 0x14a30b
            //   66c745a04300         | mov                 dword ptr [ebp - 0x80], ecx
            //   eb03                 | sub                 eax, edx
            //   8a45a0               | mov                 word ptr [ebp - 0x7c], ax

        $sequence_14 = { 8bcc 8d85e8fcffff 50 e8???????? }
            // n = 4, score = 200
            //   8bcc                 | add                 esp, 0x74
            //   8d85e8fcffff         | push                eax
            //   50                   | add                 esp, 0x84
            //   e8????????           |                     

        $sequence_15 = { 894d94 b925000000 e8???????? 0fb64d8f }
            // n = 4, score = 200
            //   894d94               | mov                 dword ptr [ebp - 0x6c], ecx
            //   b925000000           | mov                 ecx, 0x25
            //   e8????????           |                     
            //   0fb64d8f             | movzx               ecx, byte ptr [ebp - 0x71]

        $sequence_16 = { ba51754269 2bca 69c10ba31400 894d80 }
            // n = 4, score = 200
            //   ba51754269           | mov                 word ptr [ebp - 0x7c], ax
            //   2bca                 | sub                 ecx, edx
            //   69c10ba31400         | mov                 byte ptr [ebp + eax - 0x78], cl
            //   894d80               | dec                 eax

        $sequence_17 = { e8???????? 0fb64d8f 4c8be0 440fb6458e }
            // n = 4, score = 200
            //   e8????????           |                     
            //   0fb64d8f             | dec                 eax
            //   4c8be0               | inc                 eax
            //   440fb6458e           | dec                 eax

    condition:
        7 of them and filesize < 4891648
}