rule win_stinger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.stinger."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stinger"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c404 8b5dfc 53 83c324 53 8b1b }
            // n = 6, score = 200
            //   83c404               | add                 esp, 4
            //   8b5dfc               | mov                 ebx, dword ptr [ebp - 4]
            //   53                   | push                ebx
            //   83c324               | add                 ebx, 0x24
            //   53                   | push                ebx
            //   8b1b                 | mov                 ebx, dword ptr [ebx]

        $sequence_1 = { 85db 7409 53 e8???????? 83c404 ff75f0 ff75f4 }
            // n = 7, score = 200
            //   85db                 | test                ebx, ebx
            //   7409                 | je                  0xb
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   ff75f4               | push                dword ptr [ebp - 0xc]

        $sequence_2 = { 83f90a 1bd2 83d100 c1e008 8d4cd137 0bc1 }
            // n = 6, score = 200
            //   83f90a               | cmp                 ecx, 0xa
            //   1bd2                 | sbb                 edx, edx
            //   83d100               | adc                 ecx, 0
            //   c1e008               | shl                 eax, 8
            //   8d4cd137             | lea                 ecx, [ecx + edx*8 + 0x37]
            //   0bc1                 | or                  eax, ecx

        $sequence_3 = { 8b5dfc 83c320 895df8 8b5df8 }
            // n = 4, score = 200
            //   8b5dfc               | mov                 ebx, dword ptr [ebp - 4]
            //   83c320               | add                 ebx, 0x20
            //   895df8               | mov                 dword ptr [ebp - 8], ebx
            //   8b5df8               | mov                 ebx, dword ptr [ebp - 8]

        $sequence_4 = { 83f800 0f84e6030000 ff75fc 8b5d08 ff33 b902000000 e8???????? }
            // n = 7, score = 200
            //   83f800               | cmp                 eax, 0
            //   0f84e6030000         | je                  0x3ec
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   ff33                 | push                dword ptr [ebx]
            //   b902000000           | mov                 ecx, 2
            //   e8????????           |                     

        $sequence_5 = { ff35???????? ff35???????? b903000000 e8???????? 83c40c 8945c4 6805000080 }
            // n = 7, score = 200
            //   ff35????????         |                     
            //   ff35????????         |                     
            //   b903000000           | mov                 ecx, 3
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8945c4               | mov                 dword ptr [ebp - 0x3c], eax
            //   6805000080           | push                0x80000005

        $sequence_6 = { 51 53 890b 50 3bc8 0f8f56030000 }
            // n = 6, score = 200
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   890b                 | mov                 dword ptr [ebx], ecx
            //   50                   | push                eax
            //   3bc8                 | cmp                 ecx, eax
            //   0f8f56030000         | jg                  0x35c

        $sequence_7 = { 8b5dfc 83c314 895df8 8965f4 6800000000 ff15???????? 90 }
            // n = 7, score = 200
            //   8b5dfc               | mov                 ebx, dword ptr [ebp - 4]
            //   83c314               | add                 ebx, 0x14
            //   895df8               | mov                 dword ptr [ebp - 8], ebx
            //   8965f4               | mov                 dword ptr [ebp - 0xc], esp
            //   6800000000           | push                0
            //   ff15????????         |                     
            //   90                   | nop                 

        $sequence_8 = { 8a143a 8a0c30 32ca 5a 880c10 }
            // n = 5, score = 200
            //   8a143a               | mov                 dl, byte ptr [edx + edi]
            //   8a0c30               | mov                 cl, byte ptr [eax + esi]
            //   32ca                 | xor                 cl, dl
            //   5a                   | pop                 edx
            //   880c10               | mov                 byte ptr [eax + edx], cl

        $sequence_9 = { 8b5df8 8b7df4 85db 8b75fc 7436 0fb606 8bc8 }
            // n = 7, score = 200
            //   8b5df8               | mov                 ebx, dword ptr [ebp - 8]
            //   8b7df4               | mov                 edi, dword ptr [ebp - 0xc]
            //   85db                 | test                ebx, ebx
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   7436                 | je                  0x38
            //   0fb606               | movzx               eax, byte ptr [esi]
            //   8bc8                 | mov                 ecx, eax

    condition:
        7 of them and filesize < 197096
}