rule win_stormwind_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.stormwind."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stormwind"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb87 85db 7483 8b7d08 8d7308 }
            // n = 5, score = 100
            //   eb87                 | jmp                 0xffffff89
            //   85db                 | test                ebx, ebx
            //   7483                 | je                  0xffffff85
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8d7308               | lea                 esi, [ebx + 8]

        $sequence_1 = { 83663800 83630800 e8???????? e8???????? c3 833d????????00 746e }
            // n = 7, score = 100
            //   83663800             | and                 dword ptr [esi + 0x38], 0
            //   83630800             | and                 dword ptr [ebx + 8], 0
            //   e8????????           |                     
            //   e8????????           |                     
            //   c3                   | ret                 
            //   833d????????00       |                     
            //   746e                 | je                  0x70

        $sequence_2 = { eb5c 8b45f4 8b0c85d8310510 f644190448 7437 8a06 }
            // n = 6, score = 100
            //   eb5c                 | jmp                 0x5e
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b0c85d8310510       | mov                 ecx, dword ptr [eax*4 + 0x100531d8]
            //   f644190448           | test                byte ptr [ecx + ebx + 4], 0x48
            //   7437                 | je                  0x39
            //   8a06                 | mov                 al, byte ptr [esi]

        $sequence_3 = { 8908 8d5602 8d4d0c e8???????? 8d4df0 83c404 }
            // n = 6, score = 100
            //   8908                 | mov                 dword ptr [eax], ecx
            //   8d5602               | lea                 edx, [esi + 2]
            //   8d4d0c               | lea                 ecx, [ebp + 0xc]
            //   e8????????           |                     
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   83c404               | add                 esp, 4

        $sequence_4 = { 8b06 83c41c 8bc8 8d7901 }
            // n = 4, score = 100
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   83c41c               | add                 esp, 0x1c
            //   8bc8                 | mov                 ecx, eax
            //   8d7901               | lea                 edi, [ecx + 1]

        $sequence_5 = { e9???????? c745dca43e0410 8b4508 8b7510 dd00 dc4df8 }
            // n = 6, score = 100
            //   e9????????           |                     
            //   c745dca43e0410       | mov                 dword ptr [ebp - 0x24], 0x10043ea4
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]
            //   dd00                 | fld                 qword ptr [eax]
            //   dc4df8               | fmul                qword ptr [ebp - 8]

        $sequence_6 = { 8b7510 85f6 0f847f010000 8b5e14 85db 0f8874010000 }
            // n = 6, score = 100
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]
            //   85f6                 | test                esi, esi
            //   0f847f010000         | je                  0x185
            //   8b5e14               | mov                 ebx, dword ptr [esi + 0x14]
            //   85db                 | test                ebx, ebx
            //   0f8874010000         | js                  0x17a

        $sequence_7 = { 53 e8???????? 8bf0 83c404 8975e8 6a00 6a00 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c404               | add                 esp, 4
            //   8975e8               | mov                 dword ptr [ebp - 0x18], esi
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_8 = { 751b 8b450c 891f 8918 8bc7 8b4df4 }
            // n = 6, score = 100
            //   751b                 | jne                 0x1d
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   891f                 | mov                 dword ptr [edi], ebx
            //   8918                 | mov                 dword ptr [eax], ebx
            //   8bc7                 | mov                 eax, edi
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_9 = { 8bf8 59 83ffff 7407 8b34bd286c0410 56 e8???????? }
            // n = 7, score = 100
            //   8bf8                 | mov                 edi, eax
            //   59                   | pop                 ecx
            //   83ffff               | cmp                 edi, -1
            //   7407                 | je                  9
            //   8b34bd286c0410       | mov                 esi, dword ptr [edi*4 + 0x10046c28]
            //   56                   | push                esi
            //   e8????????           |                     

    condition:
        7 of them and filesize < 741376
}