rule win_strelastealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.strelastealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.strelastealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d0575910000 41b91b000000 4889442420 e8???????? 4883c438 }
            // n = 5, score = 100
            //   488d0575910000       | cmp                 ebx, eax
            //   41b91b000000         | je                  0xffffffd3
            //   4889442420           | dec                 eax
            //   e8????????           |                     
            //   4883c438             | mov                 ecx, ebx

        $sequence_1 = { ff15???????? 85c0 0f854effffff 488bcb ff15???????? 4881c4d8050000 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f854effffff         | jne                 0xffffff54
            //   488bcb               | dec                 eax
            //   ff15????????         |                     
            //   4881c4d8050000       | mov                 ecx, ebx

        $sequence_2 = { 50 e8???????? 8b44242c 83c40c 53 53 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b44242c             | mov                 eax, dword ptr [esp + 0x2c]
            //   83c40c               | add                 esp, 0xc
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_3 = { 08c1 20ca 80f101 89c8 }
            // n = 4, score = 100
            //   08c1                 | and                 dl, 1
            //   20ca                 | xor                 bl, 1
            //   80f101               | or                  cl, al
            //   89c8                 | or                  bl, dl

        $sequence_4 = { a1???????? 668b08 56 8d5306 55 }
            // n = 5, score = 100
            //   a1????????           |                     
            //   668b08               | mov                 cx, word ptr [eax]
            //   56                   | push                esi
            //   8d5306               | lea                 edx, [ebx + 6]
            //   55                   | push                ebp

        $sequence_5 = { 488bc2 488d0d05c50000 0f57c0 48890b }
            // n = 4, score = 100
            //   488bc2               | lea                 ecx, [0xa387]
            //   488d0d05c50000       | dec                 eax
            //   0f57c0               | lea                 eax, [0x9175]
            //   48890b               | inc                 ecx

        $sequence_6 = { 015304 eb55 4d85c0 7e27 488bd7 4c8b4dc7 4b8b8ccbc0120600 }
            // n = 7, score = 100
            //   015304               | test                eax, eax
            //   eb55                 | je                  0x1b
            //   4d85c0               | dec                 eax
            //   7e27                 | mov                 ecx, ebx
            //   488bd7               | dec                 eax
            //   4c8b4dc7             | mov                 eax, edx
            //   4b8b8ccbc0120600     | dec                 eax

        $sequence_7 = { 53 53 6804010000 8d94247c030000 52 }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   6804010000           | push                0x104
            //   8d94247c030000       | lea                 edx, [esp + 0x37c]
            //   52                   | push                edx

        $sequence_8 = { 488d05bd430100 488945e0 895128 488d0d87a30000 }
            // n = 4, score = 100
            //   488d05bd430100       | mov                 ecx, edi
            //   488945e0             | dec                 eax
            //   895128               | lea                 eax, [0xffaf]
            //   488d0d87a30000       | dec                 eax

        $sequence_9 = { 56 53 57 ff15???????? 8bf0 8b442418 8930 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   53                   | push                ebx
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8930                 | mov                 dword ptr [eax], esi

        $sequence_10 = { 08c1 08da 80f201 89c8 }
            // n = 4, score = 100
            //   08c1                 | dec                 eax
            //   08da                 | sub                 esp, 0x20
            //   80f201               | dec                 eax
            //   89c8                 | mov                 ecx, esi

        $sequence_11 = { 08c1 0f1f440000 b810000000 e8???????? }
            // n = 4, score = 100
            //   08c1                 | add                 eax, edi
            //   0f1f440000           | jne                 0x23
            //   b810000000           | dec                 eax
            //   e8????????           |                     

        $sequence_12 = { b913000000 4c8d05d3800000 e8???????? 4885c0 7417 49ba7032d8542306ddea }
            // n = 6, score = 100
            //   b913000000           | mov                 ecx, 0x1b
            //   4c8d05d3800000       | dec                 eax
            //   e8????????           |                     
            //   4885c0               | mov                 dword ptr [esp + 0x20], eax
            //   7417                 | dec                 eax
            //   49ba7032d8542306ddea     | add    esp, 0x38

        $sequence_13 = { 488d05afff0000 483bd8 74d1 488bcb }
            // n = 4, score = 100
            //   488d05afff0000       | lea                 ecx, [esp + 0x30]
            //   483bd8               | dec                 eax
            //   74d1                 | lea                 edi, [0x15e2a]
            //   488bcb               | dec                 eax

        $sequence_14 = { 8945e4 3d00010000 7d10 8a8c181d010000 888810b80010 40 }
            // n = 6, score = 100
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   3d00010000           | cmp                 eax, 0x100
            //   7d10                 | jge                 0x12
            //   8a8c181d010000       | mov                 cl, byte ptr [eax + ebx + 0x11d]
            //   888810b80010         | mov                 byte ptr [eax + 0x1000b810], cl
            //   40                   | inc                 eax

        $sequence_15 = { 03c7 751f 488b85a0010000 488b8888000000 488d0505540100 }
            // n = 5, score = 100
            //   03c7                 | sub                 eax, ecx
            //   751f                 | mov                 ecx, 0xd35688dd
            //   488b85a0010000       | sub                 ecx, eax
            //   488b8888000000       | add                 ecx, eax
            //   488d0505540100       | mov                 eax, 0xd35688dc

        $sequence_16 = { 50 6819000200 53 8d8c246c010000 51 6801000080 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   6819000200           | push                0x20019
            //   53                   | push                ebx
            //   8d8c246c010000       | lea                 ecx, [esp + 0x16c]
            //   51                   | push                ecx
            //   6801000080           | push                0x80000001

        $sequence_17 = { 488d4c2430 ff15???????? 488d3d2a5e0100 488bcf ff15???????? }
            // n = 5, score = 100
            //   488d4c2430           | dec                 eax
            //   ff15????????         |                     
            //   488d3d2a5e0100       | add                 esp, 0x5d8
            //   488bcf               | dec                 eax
            //   ff15????????         |                     

        $sequence_18 = { 0fb6c0 eb12 8b45e0 8a8014b90010 08443b1d 0fb64601 47 }
            // n = 7, score = 100
            //   0fb6c0               | movzx               eax, al
            //   eb12                 | jmp                 0x14
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8a8014b90010         | mov                 al, byte ptr [eax + 0x1000b914]
            //   08443b1d             | or                  byte ptr [ebx + edi + 0x1d], al
            //   0fb64601             | movzx               eax, byte ptr [esi + 1]
            //   47                   | inc                 edi

        $sequence_19 = { 01c7 897d14 8d1401 81c200040000 }
            // n = 4, score = 100
            //   01c7                 | dec                 eax
            //   897d14               | inc                 edx
            //   8d1401               | dec                 ecx
            //   81c200040000         | cmp                 edx, esi

        $sequence_20 = { 01c1 b8dc8856d3 29c8 b9dd8856d3 }
            // n = 4, score = 100
            //   01c1                 | lea                 ecx, [0xc505]
            //   b8dc8856d3           | xorps               xmm0, xmm0
            //   29c8                 | dec                 eax
            //   b9dd8856d3           | mov                 dword ptr [ebx], ecx

        $sequence_21 = { 33c9 4c8d054be10000 488d154ce10000 e8???????? 4885c0 740f 488bcb }
            // n = 7, score = 100
            //   33c9                 | dec                 eax
            //   4c8d054be10000       | lea                 eax, [0x143bd]
            //   488d154ce10000       | dec                 eax
            //   e8????????           |                     
            //   4885c0               | mov                 dword ptr [ebp - 0x20], eax
            //   740f                 | mov                 dword ptr [ecx + 0x28], edx
            //   488bcb               | dec                 eax

        $sequence_22 = { 305106 33d2 f7f6 0fb68220a30010 304107 }
            // n = 5, score = 100
            //   305106               | xor                 byte ptr [ecx + 6], dl
            //   33d2                 | xor                 edx, edx
            //   f7f6                 | div                 esi
            //   0fb68220a30010       | movzx               eax, byte ptr [edx + 0x1000a320]
            //   304107               | xor                 byte ptr [ecx + 7], al

        $sequence_23 = { 08c1 08d3 89ca 80e201 }
            // n = 4, score = 100
            //   08c1                 | add                 edi, eax
            //   08d3                 | mov                 dword ptr [ebp + 0x14], edi
            //   89ca                 | lea                 edx, [ecx + eax]
            //   80e201               | add                 edx, 0x400

    condition:
        7 of them and filesize < 872448
}