rule win_stuxnet_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.stuxnet."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stuxnet"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 84c0 7504 804e1104 e8???????? 84c0 7404 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7504                 | jne                 6
            //   804e1104             | or                  byte ptr [esi + 0x11], 4
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7404                 | je                  6

        $sequence_1 = { ff750c 8d4580 50 e8???????? 33db 895dfc 8d4580 }
            // n = 7, score = 200
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8d4580               | lea                 eax, [ebp - 0x80]
            //   50                   | push                eax
            //   e8????????           |                     
            //   33db                 | xor                 ebx, ebx
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   8d4580               | lea                 eax, [ebp - 0x80]

        $sequence_2 = { ff75f8 8d963c0b0000 57 e8???????? 59 59 5f }
            // n = 7, score = 200
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   8d963c0b0000         | lea                 edx, [esi + 0xb3c]
            //   57                   | push                edi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi

        $sequence_3 = { c3 8b44240c 8906 33c0 40 5e c3 }
            // n = 7, score = 200
            //   c3                   | ret                 
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   8906                 | mov                 dword ptr [esi], eax
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   5e                   | pop                 esi
            //   c3                   | ret                 

        $sequence_4 = { 8d4580 50 8d8540ffffff 50 e8???????? c645fc05 50 }
            // n = 7, score = 200
            //   8d4580               | lea                 eax, [ebp - 0x80]
            //   50                   | push                eax
            //   8d8540ffffff         | lea                 eax, [ebp - 0xc0]
            //   50                   | push                eax
            //   e8????????           |                     
            //   c645fc05             | mov                 byte ptr [ebp - 4], 5
            //   50                   | push                eax

        $sequence_5 = { e8???????? ff75c8 8d45ec 50 e8???????? ff75c9 8d45ec }
            // n = 7, score = 200
            //   e8????????           |                     
            //   ff75c8               | push                dword ptr [ebp - 0x38]
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   e8????????           |                     
            //   ff75c9               | push                dword ptr [ebp - 0x37]
            //   8d45ec               | lea                 eax, [ebp - 0x14]

        $sequence_6 = { b8???????? e8???????? 51 8365f000 56 8b7508 8d45f0 }
            // n = 7, score = 200
            //   b8????????           |                     
            //   e8????????           |                     
            //   51                   | push                ecx
            //   8365f000             | and                 dword ptr [ebp - 0x10], 0
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8d45f0               | lea                 eax, [ebp - 0x10]

        $sequence_7 = { e8???????? eb02 33c0 c645fc00 8b7d08 83c704 50 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   c645fc00             | mov                 byte ptr [ebp - 4], 0
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   83c704               | add                 edi, 4
            //   50                   | push                eax

        $sequence_8 = { e8???????? 8906 895604 c9 c3 8b08 8b4004 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8906                 | mov                 dword ptr [esi], eax
            //   895604               | mov                 dword ptr [esi + 4], edx
            //   c9                   | leave               
            //   c3                   | ret                 
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]

        $sequence_9 = { 8955ec c7042410270000 e8???????? c645fc01 8b0e 8b01 6a02 }
            // n = 7, score = 200
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   c7042410270000       | mov                 dword ptr [esp], 0x2710
            //   e8????????           |                     
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   6a02                 | push                2

    condition:
        7 of them and filesize < 2495488
}