rule win_suncrypt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.suncrypt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.suncrypt"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33d2 c68518ffffff6e c68519ffffff64 c6851affffff13 c6851bffffff2d c6851cffffff28 c6851dffffff28 }
            // n = 7, score = 200
            //   33d2                 | xor                 edx, edx
            //   c68518ffffff6e       | mov                 byte ptr [ebp - 0xe8], 0x6e
            //   c68519ffffff64       | mov                 byte ptr [ebp - 0xe7], 0x64
            //   c6851affffff13       | mov                 byte ptr [ebp - 0xe6], 0x13
            //   c6851bffffff2d       | mov                 byte ptr [ebp - 0xe5], 0x2d
            //   c6851cffffff28       | mov                 byte ptr [ebp - 0xe4], 0x28
            //   c6851dffffff28       | mov                 byte ptr [ebp - 0xe3], 0x28

        $sequence_1 = { 0fbec0 33c1 884415c8 42 83fa1c 72e9 8d4dc8 }
            // n = 7, score = 200
            //   0fbec0               | movsx               eax, al
            //   33c1                 | xor                 eax, ecx
            //   884415c8             | mov                 byte ptr [ebp + edx - 0x38], al
            //   42                   | inc                 edx
            //   83fa1c               | cmp                 edx, 0x1c
            //   72e9                 | jb                  0xffffffeb
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]

        $sequence_2 = { 6a00 6a00 6a00 6a00 ff35???????? be00310884 c745e000010000 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff35????????         |                     
            //   be00310884           | mov                 esi, 0x84083100
            //   c745e000010000       | mov                 dword ptr [ebp - 0x20], 0x100

        $sequence_3 = { 0405 83f031 8845f9 8b45f0 0406 83f02e 8845fa }
            // n = 7, score = 200
            //   0405                 | add                 al, 5
            //   83f031               | xor                 eax, 0x31
            //   8845f9               | mov                 byte ptr [ebp - 7], al
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   0406                 | add                 al, 6
            //   83f02e               | xor                 eax, 0x2e
            //   8845fa               | mov                 byte ptr [ebp - 6], al

        $sequence_4 = { 8bec 8a5508 80fa2c 7446 a0???????? b9???????? 84c0 }
            // n = 7, score = 200
            //   8bec                 | mov                 ebp, esp
            //   8a5508               | mov                 dl, byte ptr [ebp + 8]
            //   80fa2c               | cmp                 dl, 0x2c
            //   7446                 | je                  0x48
            //   a0????????           |                     
            //   b9????????           |                     
            //   84c0                 | test                al, al

        $sequence_5 = { ff15???????? 8bf0 85f6 742a 83feff 7425 8d45e8 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   742a                 | je                  0x2c
            //   83feff               | cmp                 esi, -1
            //   7425                 | je                  0x27
            //   8d45e8               | lea                 eax, [ebp - 0x18]

        $sequence_6 = { 8b7308 83c140 8b7da0 894df4 8b4df0 eb7e }
            // n = 6, score = 200
            //   8b7308               | mov                 esi, dword ptr [ebx + 8]
            //   83c140               | add                 ecx, 0x40
            //   8b7da0               | mov                 edi, dword ptr [ebp - 0x60]
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   eb7e                 | jmp                 0x80

        $sequence_7 = { 0f28dc 660ffe9df0fdffff 0f28c3 660fef45a0 0f28c8 660f72f00c 660f72d114 }
            // n = 7, score = 200
            //   0f28dc               | movaps              xmm3, xmm4
            //   660ffe9df0fdffff     | paddd               xmm3, xmmword ptr [ebp - 0x210]
            //   0f28c3               | movaps              xmm0, xmm3
            //   660fef45a0           | pxor                xmm0, xmmword ptr [ebp - 0x60]
            //   0f28c8               | movaps              xmm1, xmm0
            //   660f72f00c           | pslld               xmm0, 0xc
            //   660f72d114           | psrld               xmm1, 0x14

        $sequence_8 = { 83fa11 72e8 ff7510 8d45ec 885dfd ff750c }
            // n = 6, score = 200
            //   83fa11               | cmp                 edx, 0x11
            //   72e8                 | jb                  0xffffffea
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   885dfd               | mov                 byte ptr [ebp - 3], bl
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_9 = { 8bc3 85c9 7411 660f1f440000 803800 740b 47 }
            // n = 7, score = 200
            //   8bc3                 | mov                 eax, ebx
            //   85c9                 | test                ecx, ecx
            //   7411                 | je                  0x13
            //   660f1f440000         | nop                 word ptr [eax + eax]
            //   803800               | cmp                 byte ptr [eax], 0
            //   740b                 | je                  0xd
            //   47                   | inc                 edi

    condition:
        7 of them and filesize < 172032
}