rule win_supernova_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.supernova."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.supernova"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 1107 17 91 1f50 3339 1107 }
            // n = 6, score = 100
            //   1107                 | jo                  0x3b7
            //   17                   | sub                 dword ptr [eax], eax
            //   91                   | add                 byte ptr [edx], cl
            //   1f50                 | and                 eax, 0x286f
            //   3339                 | or                  dh, byte ptr [edx - 0x4f]
            //   1107                 | add                 dword ptr [eax], eax

        $sequence_1 = { 1308 03 6f0b00000a 6f1c00000a 1107 16 }
            // n = 6, score = 100
            //   1308                 | or                  dword ptr [eax], eax
            //   03                   | add                 byte ptr [edx], cl
            //   6f0b00000a           | pop                 ss
            //   6f1c00000a           | lea                 edx, [ebx]
            //   1107                 | add                 byte ptr [eax], al
            //   16                   | add                 dword ptr [0x22772], esp

        $sequence_2 = { 26 25 6f2800000a 72b1010070 }
            // n = 4, score = 100
            //   26                   | add                 byte ptr [ebx], dh
            //   25                   | or                  al, 0x72
            //   6f2800000a           | int                 0
            //   72b1010070           | add                 byte ptr [eax + 0x13], dh

        $sequence_3 = { 19 91 1f47 3329 }
            // n = 4, score = 100
            //   19                   | and                 byte ptr [ecx + 0x33000000], cl
            //   91                   | inc                 ecx
            //   1f47                 | push                ss
            //   3329                 | xchg                eax, ecx

        $sequence_4 = { 3341 1107 17 91 1f50 3339 }
            // n = 6, score = 100
            //   3341                 | or                  dword ptr [edi + 0x22], ebp
            //   1107                 | add                 byte ptr [eax], al
            //   17                   | or                  bl, dh
            //   91                   | add                 byte ptr [esi], dl
            //   1f50                 | adc                 dword ptr [edi], eax
            //   3339                 | mov                 gs, word ptr [ecx + 0x6f]

        $sequence_5 = { 1f0a 9d 6f0a00000a 1304 03 6f0b00000a }
            // n = 6, score = 100
            //   1f0a                 | and                 dword ptr [eax], eax
            //   9d                   | add                 byte ptr [edx], cl
            //   6f0a00000a           | fiadd               word ptr [esi + 0x13]
            //   1304                 | or                  dword ptr [ebx], eax
            //   03                   | outsd               dx, dword ptr [esi]
            //   6f0b00000a           | or                  eax, dword ptr [eax]

        $sequence_6 = { de00 03 6f0800000a 6f0e00000a }
            // n = 4, score = 100
            //   de00                 | or                  ch, byte ptr [edi + 0x2d]
            //   03                   | add                 byte ptr [eax], al
            //   6f0800000a           | or                  ch, byte ptr [edi + 0x35]
            //   6f0e00000a           | add                 byte ptr [eax], al

        $sequence_7 = { 3309 72e3000070 1308 2b5a 1107 }
            // n = 5, score = 100
            //   3309                 | adc                 dword ptr [edi], eax
            //   72e3000070           | pop                 ss
            //   1308                 | outsd               dx, dword ptr [esi]
            //   2b5a                 | pop                 ds
            //   1107                 | add                 byte ptr [eax], al

        $sequence_8 = { 16 91 2089000000 3341 }
            // n = 4, score = 100
            //   16                   | adc                 eax, dword ptr [esi]
            //   91                   | sub                 eax, dword ptr [edi]
            //   2089000000           | sub                 byte ptr [0x130a0000], dl
            //   3341                 | push                es

        $sequence_9 = { 7e01000004 7211010070 1109 6f2200000a de00 03 6f0b00000a }
            // n = 7, score = 100
            //   7e01000004           | adc                 al, byte ptr [eax]
            //   7211010070           | add                 byte ptr [edx], cl
            //   1109                 | sub                 eax, 0x6f051128
            //   6f2200000a           | adc                 dword ptr [eax], eax
            //   de00                 | add                 byte ptr [edx], cl
            //   03                   | jae                 0x33
            //   6f0b00000a           | add                 byte ptr [eax], al

    condition:
        7 of them and filesize < 50176
}