rule win_suppobox_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.suppobox."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.suppobox"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7e10 a1???????? 0305???????? a3???????? }
            // n = 4, score = 200
            //   7e10                 | jle                 0x12
            //   a1????????           |                     
            //   0305????????         |                     
            //   a3????????           |                     

        $sequence_1 = { 3bc8 7d10 a1???????? 2b05???????? a3???????? }
            // n = 5, score = 200
            //   3bc8                 | cmp                 ecx, eax
            //   7d10                 | jge                 0x12
            //   a1????????           |                     
            //   2b05????????         |                     
            //   a3????????           |                     

        $sequence_2 = { 890d???????? e8???????? 8bf0 e8???????? 03f0 }
            // n = 5, score = 200
            //   890d????????         |                     
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     
            //   03f0                 | add                 esi, eax

        $sequence_3 = { 8945f0 a1???????? 83e801 a3???????? }
            // n = 4, score = 200
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   a1????????           |                     
            //   83e801               | sub                 eax, 1
            //   a3????????           |                     

        $sequence_4 = { 7412 8b0d???????? 030d???????? 890d???????? }
            // n = 4, score = 200
            //   7412                 | je                  0x14
            //   8b0d????????         |                     
            //   030d????????         |                     
            //   890d????????         |                     

        $sequence_5 = { 7d10 a1???????? 0b05???????? a3???????? }
            // n = 4, score = 200
            //   7d10                 | jge                 0x12
            //   a1????????           |                     
            //   0b05????????         |                     
            //   a3????????           |                     

        $sequence_6 = { 7f10 a1???????? 2305???????? a3???????? }
            // n = 4, score = 200
            //   7f10                 | jg                  0x12
            //   a1????????           |                     
            //   2305????????         |                     
            //   a3????????           |                     

        $sequence_7 = { 01c6 39fe 0f8d2f020000 80bc2ef4f7ffff0a }
            // n = 4, score = 100
            //   01c6                 | add                 esi, eax
            //   39fe                 | cmp                 esi, edi
            //   0f8d2f020000         | jge                 0x235
            //   80bc2ef4f7ffff0a     | cmp                 byte ptr [esi + ebp - 0x80c], 0xa

        $sequence_8 = { 019dacf7ffff 83c40c 299dc4f7ffff e9???????? }
            // n = 4, score = 100
            //   019dacf7ffff         | add                 dword ptr [ebp - 0x854], ebx
            //   83c40c               | add                 esp, 0xc
            //   299dc4f7ffff         | sub                 dword ptr [ebp - 0x83c], ebx
            //   e9????????           |                     

        $sequence_9 = { 8d48ff 2d9b507602 8985dcfdffff db85dcfdffff }
            // n = 4, score = 100
            //   8d48ff               | lea                 ecx, [eax - 1]
            //   2d9b507602           | sub                 eax, 0x276509b
            //   8985dcfdffff         | mov                 dword ptr [ebp - 0x224], eax
            //   db85dcfdffff         | fild                dword ptr [ebp - 0x224]

        $sequence_10 = { 01c6 39fe 0f8d7e010000 80bc2ef4f7ffff0a }
            // n = 4, score = 100
            //   01c6                 | add                 esi, eax
            //   39fe                 | cmp                 esi, edi
            //   0f8d7e010000         | jge                 0x184
            //   80bc2ef4f7ffff0a     | cmp                 byte ptr [esi + ebp - 0x80c], 0xa

        $sequence_11 = { 8d48ff 2d9696ca2f 39c2 66898d92feffff 0f8dbbfcffff }
            // n = 5, score = 100
            //   8d48ff               | lea                 ecx, [eax - 1]
            //   2d9696ca2f           | sub                 eax, 0x2fca9696
            //   39c2                 | cmp                 edx, eax
            //   66898d92feffff       | mov                 word ptr [ebp - 0x16e], cx
            //   0f8dbbfcffff         | jge                 0xfffffcc1

        $sequence_12 = { 01bdacf7ffff 83c40c 83bdc8f7ffff00 8b95c8f7ffff }
            // n = 4, score = 100
            //   01bdacf7ffff         | add                 dword ptr [ebp - 0x854], edi
            //   83c40c               | add                 esp, 0xc
            //   83bdc8f7ffff00       | cmp                 dword ptr [ebp - 0x838], 0
            //   8b95c8f7ffff         | mov                 edx, dword ptr [ebp - 0x838]

        $sequence_13 = { 01d8 3b85b0f7ffff 7e2f 8b95c8f7ffff }
            // n = 4, score = 100
            //   01d8                 | add                 eax, ebx
            //   3b85b0f7ffff         | cmp                 eax, dword ptr [ebp - 0x850]
            //   7e2f                 | jle                 0x31
            //   8b95c8f7ffff         | mov                 edx, dword ptr [ebp - 0x838]

        $sequence_14 = { 8d48ff 39c2 890d???????? 0f8e93240000 }
            // n = 4, score = 100
            //   8d48ff               | lea                 ecx, [eax - 1]
            //   39c2                 | cmp                 edx, eax
            //   890d????????         |                     
            //   0f8e93240000         | jle                 0x2499

        $sequence_15 = { 8d48ff 2de13d1921 8985e0f8ffff db85e0f8ffff }
            // n = 4, score = 100
            //   8d48ff               | lea                 ecx, [eax - 1]
            //   2de13d1921           | sub                 eax, 0x21193de1
            //   8985e0f8ffff         | mov                 dword ptr [ebp - 0x720], eax
            //   db85e0f8ffff         | fild                dword ptr [ebp - 0x720]

        $sequence_16 = { 01d7 68???????? 57 e8???????? }
            // n = 4, score = 100
            //   01d7                 | add                 edi, edx
            //   68????????           |                     
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_17 = { 8d48ff 39c2 898db4f8ffff 0f8e3d0f0000 }
            // n = 4, score = 100
            //   8d48ff               | lea                 ecx, [eax - 1]
            //   39c2                 | cmp                 edx, eax
            //   898db4f8ffff         | mov                 dword ptr [ebp - 0x74c], ecx
            //   0f8e3d0f0000         | jle                 0xf43

        $sequence_18 = { 01c6 ebdb ff7510 57 }
            // n = 4, score = 100
            //   01c6                 | add                 esi, eax
            //   ebdb                 | jmp                 0xffffffdd
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   57                   | push                edi

        $sequence_19 = { 01c9 4a 79f2 833b54 }
            // n = 4, score = 100
            //   01c9                 | add                 ecx, ecx
            //   4a                   | dec                 edx
            //   79f2                 | jns                 0xfffffff4
            //   833b54               | cmp                 dword ptr [ebx], 0x54

        $sequence_20 = { 8d48ff 2dbb4fb754 39c2 66890d???????? }
            // n = 4, score = 100
            //   8d48ff               | lea                 ecx, [eax - 1]
            //   2dbb4fb754           | sub                 eax, 0x54b74fbb
            //   39c2                 | cmp                 edx, eax
            //   66890d????????       |                     

        $sequence_21 = { 8d48ff 39c2 898dc8feffff 0f8ebb010000 }
            // n = 4, score = 100
            //   8d48ff               | lea                 ecx, [eax - 1]
            //   39c2                 | cmp                 edx, eax
            //   898dc8feffff         | mov                 dword ptr [ebp - 0x138], ecx
            //   0f8ebb010000         | jle                 0x1c1

    condition:
        7 of them and filesize < 1875968
}