rule win_swen_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.swen."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.swen"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? 8d85e0fdffff 50 e8???????? 59 59 53 }
            // n = 7, score = 100
            //   68????????           |                     
            //   8d85e0fdffff         | lea                 eax, [ebp - 0x220]
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   53                   | push                ebx

        $sequence_1 = { 895dfc 68c8000000 53 68???????? e8???????? 83c40c 891d???????? }
            // n = 7, score = 100
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   68c8000000           | push                0xc8
            //   53                   | push                ebx
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   891d????????         |                     

        $sequence_2 = { 8d8564ffffff eb03 8d45c8 50 8d8540feffff 50 e8???????? }
            // n = 7, score = 100
            //   8d8564ffffff         | lea                 eax, [ebp - 0x9c]
            //   eb03                 | jmp                 5
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   50                   | push                eax
            //   8d8540feffff         | lea                 eax, [ebp - 0x1c0]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_3 = { 85c0 740a e8???????? e9???????? 8d85bcfcffff 50 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   740a                 | je                  0xc
            //   e8????????           |                     
            //   e9????????           |                     
            //   8d85bcfcffff         | lea                 eax, [ebp - 0x344]
            //   50                   | push                eax

        $sequence_4 = { 0f84f8020000 8d7801 803f79 750a c78574feffff01000000 8818 8d8581feffff }
            // n = 7, score = 100
            //   0f84f8020000         | je                  0x2fe
            //   8d7801               | lea                 edi, [eax + 1]
            //   803f79               | cmp                 byte ptr [edi], 0x79
            //   750a                 | jne                 0xc
            //   c78574feffff01000000     | mov    dword ptr [ebp - 0x18c], 1
            //   8818                 | mov                 byte ptr [eax], bl
            //   8d8581feffff         | lea                 eax, [ebp - 0x17f]

        $sequence_5 = { 85c0 0f85ccfdffff 6820bf0200 e8???????? 59 8bf8 89bd1cfeffff }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f85ccfdffff         | jne                 0xfffffdd2
            //   6820bf0200           | push                0x2bf20
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8bf8                 | mov                 edi, eax
            //   89bd1cfeffff         | mov                 dword ptr [ebp - 0x1e4], edi

        $sequence_6 = { 83c40c 85c0 750c 834dfcff 6a01 58 e9???????? }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   6a01                 | push                1
            //   58                   | pop                 eax
            //   e9????????           |                     

        $sequence_7 = { 680000aa00 ff15???????? 8945d0 6a08 ff15???????? 50 ff75a8 }
            // n = 7, score = 100
            //   680000aa00           | push                0xaa0000
            //   ff15????????         |                     
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   6a08                 | push                8
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff75a8               | push                dword ptr [ebp - 0x58]

        $sequence_8 = { 57 6a01 68???????? bb???????? 53 bf02000080 57 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   6a01                 | push                1
            //   68????????           |                     
            //   bb????????           |                     
            //   53                   | push                ebx
            //   bf02000080           | mov                 edi, 0x80000002
            //   57                   | push                edi

        $sequence_9 = { 7456 6a02 53 53 57 ff15???????? ff7508 }
            // n = 7, score = 100
            //   7456                 | je                  0x58
            //   6a02                 | push                2
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   57                   | push                edi
            //   ff15????????         |                     
            //   ff7508               | push                dword ptr [ebp + 8]

    condition:
        7 of them and filesize < 286720
}